/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli.commands;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.core.VeraPDFException;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.plugins.PluginsCollectionConfig;
import org.xml.sax.SAXException;

public class VeraCliArgParser {
    static final VeraCliArgParser DEFAULT_ARGS = new VeraCliArgParser();
    static final String FLAG_SEP = "-";
    static final String OPTION_SEP = "--";
    static final String HELP_FLAG = "-h";
    static final String HELP = "--help";
    static final String VERSION = "--version";
    static final String FLAVOUR_FLAG = "-f";
    static final String FLAVOUR = "--flavour";
    static final String SUCCESS = "--success";
    static final String PASSED = "--passed";
    static final String LIST_FLAG = "-l";
    static final String LIST = "--list";
    static final String LOAD_PROFILE_FLAG = "-p";
    static final String LOAD_PROFILE = "--profile";
    static final String EXTRACT_FLAG = "-x";
    static final String EXTRACT = "--extract";
    static final String FORMAT = "--format";
    static final String RECURSE_FLAG = "-r";
    static final String RECURSE = "--recurse";
    static final String VERBOSE_FLAG = "-v";
    static final String VERBOSE = "--verbose";
    static final String MAX_FAILURES_DISPLAYED = "--maxfailuresdisplayed";
    static final String MAX_FAILURES = "--maxfailures";
    static final String FIX_METADATA = "--fixmetadata";
    static final String FIX_METADATA_PREFIX = "--prefix";
    static final String FIX_METADATA_FOLDER = "--savefolder";
    static final String POLICY_FILE = "--policyfile";
    static final String VALID_OFF_FLAG = "-o";
    static final String VALID_OFF = "--off";
    @Parameter(names={"-h", "--help"}, description="Shows this message and exits.", help=true)
    private boolean help = false;
    @Parameter(names={"--version"}, description="Displays veraPDF version information.")
    private boolean showVersion = false;
    @Parameter(names={"-f", "--flavour"}, description="Chooses built-in Validation Profile flavour, e.g. '1b'. Alternatively, supply '0' or no argument for automatic flavour detection based on a file's metadata.", converter=FlavourConverter.class)
    private PDFAFlavour flavour = PDFAFlavour.NO_FLAVOUR;
    @Parameter(names={"--success", "--passed"}, description="Logs successful validation checks.")
    private boolean passed = ValidatorFactory.defaultConfig().isRecordPasses();
    @Parameter(names={"-l", "--list"}, description="Lists built-in Validation Profiles.")
    private boolean listProfiles = false;
    @Parameter(names={"-p", "--profile"}, description="Loads a Validation Profile from given path and exits if loading fails. This overrides any choice or default implied by the -f / --flavour option.", validateWith=FileValidator.class)
    private File profileFile;
    @Parameter(names={"-x", "--extract"}, description="Extracts and reports PDF features.")
    private boolean features = false;
    @Parameter(names={"--format"}, description="Chooses output format.", converter=FormatConverter.class)
    private FormatOption format = Applications.defaultConfig().getFormat();
    @Parameter(names={"-r", "--recurse"}, description="Recurses through directories. Only files with .pdf extensions are processed.")
    private boolean isRecurse = false;
    @Parameter(names={"-v", "--verbose"}, description="Adds failed test information to text output.")
    private boolean isVerbose = false;
    @Parameter(names={"--maxfailuresdisplayed"}, description="Sets maximum amount of failed checks displayed for each rule.")
    private int maxFailuresDisplayed = 100;
    @Parameter(names={"--maxfailures"}, description="Sets maximum amount of failed checks.")
    private int maxFailures = ValidatorFactory.defaultConfig().getMaxFails();
    @Parameter(names={"--fixmetadata"}, description="Performs metadata fixes.")
    private boolean fixMetadata = false;
    @Parameter(names={"--prefix"}, description="Sets file name prefix for any fixed files.")
    private String prefix = FixerFactory.defaultConfig().getFixesPrefix();
    @Parameter(names={"--savefolder"}, description="Sets output directory for any fixed files.")
    private String saveFolder = "";
    @Parameter(names={"--policyfile"}, description="Select a policy schematron or XSL file.", validateWith=FileValidator.class)
    private File policyFile;
    @Parameter(names={"-o", "--off"}, description="Turns off PDF/A validation")
    private boolean isValidationOff = false;
    @Parameter(description="FILES")
    private List<String> pdfPaths = new ArrayList<String>();

    public boolean showVersion() {
        return this.showVersion;
    }

    public boolean listProfiles() {
        return this.listProfiles;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public int maxFailuresDisplayed() {
        return this.maxFailuresDisplayed;
    }

    public int maxFailures() {
        return this.maxFailures;
    }

    public boolean fixMetadata() {
        return this.fixMetadata;
    }

    public String prefix() {
        return this.prefix;
    }

    public String saveFolder() {
        return this.saveFolder;
    }

    public boolean isRecurse() {
        return this.isRecurse;
    }

    public boolean isHelp() {
        return this.help;
    }

    public FormatOption getFormat() {
        return this.format;
    }

    public boolean logPassed() {
        return this.passed;
    }

    public boolean extractFeatures() {
        return this.features | this.isPolicy();
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public File getProfileFile() {
        return this.profileFile;
    }

    public File getPolicyFile() {
        return this.policyFile;
    }

    public boolean isPolicy() {
        return this.policyFile != null;
    }

    public List<String> getPdfPaths() {
        return this.pdfPaths;
    }

    public boolean isValidationOff() {
        return this.isValidationOff | this.isPolicy();
    }

    public ValidatorConfig validatorConfig() {
        return ValidatorFactory.createConfig(this.flavour, this.logPassed(), this.maxFailures);
    }

    public MetadataFixerConfig fixerConfig() {
        return FixerFactory.configFromValues(this.prefix, true);
    }

    public VeraAppConfig appConfig(VeraAppConfig base) {
        Applications.Builder configBuilder = Applications.Builder.fromConfig(base);
        configBuilder.format(this.getFormat()).isVerbose(this.isVerbose()).fixerFolder(this.saveFolder);
        configBuilder.type(VeraCliArgParser.typeFromArgs(this));
        configBuilder.maxFails(this.maxFailuresDisplayed);
        return configBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessorConfig processorConfig(ProcessType procType, FeatureExtractorConfig featConfig, PluginsCollectionConfig plugConfig) throws VeraPDFException {
        Throwable throwable;
        FeatureExtractorConfig featuresConfig = featConfig;
        if (this.isPolicy()) {
            try {
                throwable = null;
                try (FileInputStream policyStream = new FileInputStream(this.policyFile);){
                    featuresConfig = ApplicationUtils.mergeEnabledFeaturesFromPolicy(featuresConfig, policyStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new VeraPDFException("Problem during obtaining feature types from policy file", e);
            }
        }
        if (this.profileFile == null) {
            return ProcessorFactory.fromValues(this.validatorConfig(), featuresConfig, plugConfig, this.fixerConfig(), procType.getTasks(), this.saveFolder);
        }
        try {
            throwable = null;
            try (FileInputStream fis = new FileInputStream(this.profileFile);){
                ValidationProfile customProfile = Profiles.profileFromXml(fis);
                ProcessorConfig processorConfig = ProcessorFactory.fromValues(this.validatorConfig(), featuresConfig, plugConfig, this.fixerConfig(), procType.getTasks(), customProfile, this.saveFolder);
                return processorConfig;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | JAXBException excep) {
            throw new VeraPDFException("Problem loading custom profile", excep);
        }
    }

    private static ProcessType typeFromArgs(VeraCliArgParser parser) {
        ProcessType retVal;
        ProcessType processType = retVal = parser.isValidationOff() && !parser.isPolicy() ? ProcessType.NO_PROCESS : ProcessType.VALIDATE;
        if (parser.extractFeatures() || parser.isPolicy()) {
            retVal = ProcessType.addProcess(retVal, ProcessType.EXTRACT);
        }
        if (parser.fixMetadata()) {
            retVal = ProcessType.addProcess(retVal, ProcessType.FIX);
        }
        return retVal;
    }

    public static final class FileValidator
    implements IParameterValidator {
        @Override
        public void validate(String name, String value) throws ParameterException {
            File profileFileLocal = new File(value);
            if (!profileFileLocal.isFile() || !profileFileLocal.canRead()) {
                throw new ParameterException("Parameter " + name + " must be the path to an existing, readable file, value=" + value);
            }
        }
    }

    public static final class FlavourConverter
    implements IStringConverter<PDFAFlavour> {
        @Override
        public PDFAFlavour convert(String value) {
            for (PDFAFlavour flavourLocal : PDFAFlavour.values()) {
                if (!flavourLocal.getId().equalsIgnoreCase(value)) continue;
                return flavourLocal;
            }
            throw new ParameterException("Illegal --flavour argument:" + value);
        }
    }

    public static final class FormatConverter
    implements IStringConverter<FormatOption> {
        @Override
        public FormatOption convert(String value) {
            try {
                return FormatOption.fromOption(value);
            }
            catch (NoSuchElementException e) {
                throw new ParameterException("Illegal format option value: " + value, e);
            }
        }
    }
}

