/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.textshow;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.markedcontent.MarkedContentHelper;
import org.verapdf.gf.model.impl.operator.textshow.GFCIDGlyph;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.operator.Glyph;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.font.type1.PDType1Font;
import org.verapdf.pd.font.type3.PDType3Font;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFGlyph
extends GenericModelObject
implements Glyph {
    private static final Logger LOGGER = Logger.getLogger(GFGlyph.class.getCanonicalName());
    public static final String GLYPH_TYPE = "Glyph";
    private static final int[] UNICODE_PRIVATE_USE_AREA_ARRAY = new int[]{57344, 63743, 983040, 1048573, 0x100000, 1114109};
    private final String id;
    private Boolean glyphPresent;
    private Boolean widthsConsistent;
    private String name;
    private String toUnicode;
    private Long renderingMode;
    private GFOpMarkedContent markedContent;
    private StructureElementAccessObject structureElementAccessObject;

    protected GFGlyph(PDFont font, int glyphCode, int renderingMode, String id, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        this(font, glyphCode, GLYPH_TYPE, renderingMode, id, markedContent, structureElementAccessObject);
    }

    protected GFGlyph(PDFont font, int glyphCode, String type, int renderingMode, String id, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        super(type);
        boolean fontProgramIsInvalid;
        FontProgram fontProgram = font.getFontProgram();
        boolean bl = fontProgramIsInvalid = (fontProgram == null || !font.isSuccessfullyParsed()) && font.getSubtype() != ASAtom.TYPE3;
        if (font.getSubtype() != ASAtom.TYPE3) {
            this.initForNotType3(fontProgramIsInvalid, fontProgram, font, glyphCode);
        } else {
            this.initForType3(font, glyphCode);
        }
        this.renderingMode = renderingMode;
        this.markedContent = markedContent;
        this.structureElementAccessObject = structureElementAccessObject;
        if (font instanceof PDSimpleFont) {
            Encoding encoding = font.getEncodingMapping();
            this.name = encoding == null ? null : encoding.getName(glyphCode);
        } else if (font instanceof PDType0Font) {
            try {
                FontProgram pr = font.getFontProgram();
                if (pr == null || !pr.isSuccessfulParsing()) {
                    this.name = null;
                } else {
                    pr.parseFont();
                    this.name = glyphCode == 0 || !font.glyphIsPresent(glyphCode) ? ".notdef" : null;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't convert code to glyph", e);
                this.name = null;
            }
        }
        this.toUnicode = StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.ISO_19005_1 ? this.getToUnicodePDFA1(font, glyphCode) : font.toUnicode(glyphCode);
        this.getactualTextPresent();
        this.id = id;
    }

    public static Glyph getGlyph(PDFont font, int glyphCode, int renderingMode, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        String id = GFIDGenerator.generateID(font.getDictionary().hashCode(), font.getName(), glyphCode, renderingMode, markedContent, structureElementAccessObject);
        Glyph cachedGlyph = StaticContainers.getCachedGlyphs().get(id);
        if (cachedGlyph == null) {
            cachedGlyph = font.getSubtype() == ASAtom.CID_FONT_TYPE0 || font.getSubtype() == ASAtom.CID_FONT_TYPE2 || font.getSubtype() == ASAtom.TYPE0 ? new GFCIDGlyph(font, glyphCode, renderingMode, id, markedContent, structureElementAccessObject) : new GFGlyph(font, glyphCode, GLYPH_TYPE, renderingMode, id, markedContent, structureElementAccessObject);
            StaticContainers.getCachedGlyphs().put(id, cachedGlyph);
        }
        return cachedGlyph;
    }

    private String getToUnicodePDFA1(PDFont font, int glyphCode) {
        if (font instanceof PDType3Font) {
            return font.cMapToUnicode(glyphCode);
        }
        if (font instanceof PDType1Font) {
            return ((PDType1Font)font).toUnicodePDFA1(glyphCode);
        }
        return font.toUnicode(glyphCode);
    }

    private void initForType3(PDFont font, int glyphCode) {
        this.glyphPresent = ((PDType3Font)font).containsCharString(glyphCode);
        this.widthsConsistent = GFGlyph.checkWidths(glyphCode, font);
    }

    private void initForNotType3(boolean fontProgramIsInvalid, FontProgram fontProgram, PDFont font, int glyphCode) {
        try {
            this.glyphPresent = null;
            this.widthsConsistent = null;
            if (!fontProgramIsInvalid) {
                fontProgram.parseFont();
                this.glyphPresent = glyphCode == 0 ? true : Boolean.valueOf(font.glyphIsPresent(glyphCode));
                this.widthsConsistent = GFGlyph.checkWidths(glyphCode, font);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error in parsing font program", e);
            StaticContainers.setValidPDF(false);
        }
    }

    private static Boolean checkWidths(int glyphCode, PDFont font) {
        Double fontWidth = font.getWidth(glyphCode);
        double expectedWidth = fontWidth == null ? 0.0 : fontWidth;
        double foundWidth = font.getWidthFromProgram(glyphCode);
        if (foundWidth == -1.0) {
            foundWidth = font.getDefaultWidth() == null ? 0.0 : font.getDefaultWidth();
        }
        return Math.abs(foundWidth - expectedWidth) > 1.0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public String getname() {
        return this.name;
    }

    @Override
    public Boolean getisWidthConsistent() {
        return this.widthsConsistent;
    }

    @Override
    public Boolean getisGlyphPresent() {
        return this.glyphPresent;
    }

    @Override
    public String gettoUnicode() {
        return this.toUnicode;
    }

    @Override
    public Long getrenderingMode() {
        return this.renderingMode;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Boolean getunicodePUA() {
        if (this.toUnicode == null) {
            return false;
        }
        for (int i = 0; i < this.toUnicode.length(); ++i) {
            int unicode = this.toUnicode.codePointAt(i);
            if (!(unicode >= UNICODE_PRIVATE_USE_AREA_ARRAY[0] && unicode <= UNICODE_PRIVATE_USE_AREA_ARRAY[1] || unicode >= UNICODE_PRIVATE_USE_AREA_ARRAY[2] && unicode <= UNICODE_PRIVATE_USE_AREA_ARRAY[3]) && (unicode < UNICODE_PRIVATE_USE_AREA_ARRAY[4] || unicode > UNICODE_PRIVATE_USE_AREA_ARRAY[5])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean getactualTextPresent() {
        return MarkedContentHelper.containsActualText(this.markedContent, this.structureElementAccessObject);
    }
}

