/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import com.adobe.xmp.impl.VeraPDFMeta;
import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.axl.AXLExtensionSchemasContainer;
import org.verapdf.model.impl.axl.AXLXMPMMHistoryProperty;
import org.verapdf.model.impl.axl.AXLXMPObject;
import org.verapdf.model.impl.axl.AXLXMPProperty;
import org.verapdf.model.tools.xmp.SchemasDefinition;
import org.verapdf.model.tools.xmp.SchemasDefinitionCreator;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class AXLXMPPackage
extends AXLXMPObject
implements XMPPackage {
    public static final String XMP_PACKAGE_TYPE = "XMPPackage";
    public static final String PROPERTIES = "Properties";
    public static final String EXTENSION_SCHEMAS_CONTAINERS = "ExtensionSchemasContainers";
    private static final String BYTES_REGEXP = "bytes\\s*=\\s*'[^']*'|bytes\\s*=\\s*\"[^\"]*\"";
    private static final String ENCODING_REGEXP = "encoding\\s*=\\s*'[^']*'|encoding\\s*=\\s*\"[^\"]*\"";
    private final VeraPDFMeta xmpMetadata;
    private final boolean isSerializationValid;
    private final boolean isMainMetadata;
    private final PDFAFlavour flavour;
    private final boolean isClosedChoiceCheck;
    private Map<String, SchemasDefinition> mainPackageSchemasDefinition;
    private Map<String, SchemasDefinition> currentSchemasDefinitionPDFA_1;
    private Map<String, SchemasDefinition> currentSchemasDefinitionPDFA_2_3;

    public AXLXMPPackage(VeraPDFMeta xmpMetadata, boolean isSerializationValid, boolean isClosedChoiceCheck, VeraPDFXMPNode mainPackageExtensionNode, PDFAFlavour flavour) {
        this(xmpMetadata, isSerializationValid, false, isClosedChoiceCheck, mainPackageExtensionNode, XMP_PACKAGE_TYPE, flavour);
    }

    public AXLXMPPackage(VeraPDFMeta xmpMetadata, boolean isSerializationValid, VeraPDFXMPNode mainPackageExtensionNode, PDFAFlavour flavour) {
        this(xmpMetadata, isSerializationValid, false, false, mainPackageExtensionNode, XMP_PACKAGE_TYPE, flavour);
    }

    protected AXLXMPPackage(VeraPDFMeta xmpMetadata, boolean isSerializationValid, boolean isMainMetadata, boolean isClosedChoiceCheck, VeraPDFXMPNode mainPackageExtensionNode, String type, PDFAFlavour flavour) {
        super(type);
        this.xmpMetadata = xmpMetadata;
        this.isSerializationValid = isSerializationValid;
        this.isMainMetadata = isMainMetadata;
        this.isClosedChoiceCheck = isClosedChoiceCheck;
        this.mainPackageSchemasDefinition = SchemasDefinitionCreator.createExtendedSchemasDefinitionForPDFA_2_3(mainPackageExtensionNode, this.isClosedChoiceCheck);
        this.flavour = flavour;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Properties": {
                return this.getXMPProperties();
            }
            case "ExtensionSchemasContainers": {
                return this.getExtensionSchemasContainers();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXLExtensionSchemasContainer> getExtensionSchemasContainers() {
        if (this.xmpMetadata != null && this.xmpMetadata.getExtensionSchemasNode() != null) {
            ArrayList<AXLExtensionSchemasContainer> res = new ArrayList<AXLExtensionSchemasContainer>(1);
            res.add(new AXLExtensionSchemasContainer(this.getXmpMetadata().getExtensionSchemasNode(), this.getCurrentSchemasDefinitionPDFA_1(), this.getCurrentSchemasDefinitionPDFA_2_3(), this.flavour));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    protected List<AXLXMPProperty> getXMPProperties() {
        if (this.getXmpMetadata() != null) {
            List<VeraPDFXMPNode> properties = this.xmpMetadata.getProperties();
            ArrayList<AXLXMPProperty> res = new ArrayList<AXLXMPProperty>(properties.size());
            for (VeraPDFXMPNode node : properties) {
                res.add(this.createProperty(node));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private AXLXMPProperty createProperty(VeraPDFXMPNode node) {
        String namespaceURI = node.getNamespaceURI();
        if ("http://ns.adobe.com/xap/1.0/mm/".equals(namespaceURI) && "History".equals(node.getName())) {
            return new AXLXMPMMHistoryProperty(node, this.isMainMetadata, this.isClosedChoiceCheck, this.getMainPackageSchemasDefinitionForNS(namespaceURI), this.getCurrentSchemasDefinitionPDFA_1ForNS(namespaceURI), this.getCurrentSchemasDefinitionPDFA_2_3ForNS(namespaceURI), this.flavour);
        }
        return new AXLXMPProperty(node, this.isMainMetadata, this.isClosedChoiceCheck, this.getMainPackageSchemasDefinitionForNS(namespaceURI), this.getCurrentSchemasDefinitionPDFA_1ForNS(namespaceURI), this.getCurrentSchemasDefinitionPDFA_2_3ForNS(namespaceURI), this.flavour);
    }

    protected VeraPDFMeta getXmpMetadata() {
        return this.xmpMetadata;
    }

    @Override
    public Boolean getisSerializationValid() {
        return this.isSerializationValid;
    }

    @Override
    public String getbytes() {
        return this.getAttributeByRegexp(BYTES_REGEXP);
    }

    @Override
    public String getencoding() {
        return this.getAttributeByRegexp(ENCODING_REGEXP);
    }

    private String getAttributeByRegexp(String regexp) {
        VeraPDFMeta xmpMetadataLocal = this.getXmpMetadata();
        if (xmpMetadataLocal == null) {
            return null;
        }
        String packetHeader = xmpMetadataLocal.getPacketHeader();
        if (packetHeader == null || packetHeader.isEmpty()) {
            return null;
        }
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(packetHeader);
        if (m.find()) {
            int dq;
            String attr = m.group();
            int sq = attr.indexOf("'");
            int min = Math.min(sq, dq = attr.indexOf("\""));
            int index = min == -1 ? Math.max(sq, dq) : min;
            return attr.substring(index + 1, attr.length() - 1);
        }
        return null;
    }

    protected Map<String, SchemasDefinition> getMainPackageSchemasDefinition() {
        if (this.mainPackageSchemasDefinition == null) {
            this.mainPackageSchemasDefinition = SchemasDefinitionCreator.EMPTY_SCHEMAS_DEFINITION;
        }
        return this.mainPackageSchemasDefinition;
    }

    protected Map<String, SchemasDefinition> getCurrentSchemasDefinitionPDFA_1() {
        if (this.currentSchemasDefinitionPDFA_1 == null) {
            this.currentSchemasDefinitionPDFA_1 = this.xmpMetadata != null && this.xmpMetadata.getExtensionSchemasNode() != null ? SchemasDefinitionCreator.createExtendedSchemasDefinitionForPDFA_1(this.xmpMetadata.getExtensionSchemasNode(), this.isClosedChoiceCheck) : SchemasDefinitionCreator.EMPTY_SCHEMAS_DEFINITION;
        }
        return this.currentSchemasDefinitionPDFA_1;
    }

    protected Map<String, SchemasDefinition> getCurrentSchemasDefinitionPDFA_2_3() {
        if (this.currentSchemasDefinitionPDFA_2_3 == null) {
            this.currentSchemasDefinitionPDFA_2_3 = this.xmpMetadata != null && this.xmpMetadata.getExtensionSchemasNode() != null ? (this.isMainMetadata ? SchemasDefinitionCreator.createExtendedSchemasDefinitionForPDFA_2_3(this.xmpMetadata.getExtensionSchemasNode(), this.isClosedChoiceCheck) : SchemasDefinitionCreator.extendSchemasDefinitionForPDFA_2_3(this.getMainPackageSchemasDefinition(), this.xmpMetadata.getExtensionSchemasNode(), this.isClosedChoiceCheck)) : SchemasDefinitionCreator.EMPTY_SCHEMAS_DEFINITION;
        }
        return this.currentSchemasDefinitionPDFA_2_3;
    }

    protected SchemasDefinition getMainPackageSchemasDefinitionForNS(String nameSpace) {
        SchemasDefinition schemasDefinition = this.getMainPackageSchemasDefinition().get(nameSpace);
        return schemasDefinition == null ? SchemasDefinitionCreator.EMPTY_SCHEMA_DEFINITION : schemasDefinition;
    }

    protected SchemasDefinition getCurrentSchemasDefinitionPDFA_1ForNS(String nameSpace) {
        SchemasDefinition schemasDefinition = this.getCurrentSchemasDefinitionPDFA_1().get(nameSpace);
        return schemasDefinition == null ? SchemasDefinitionCreator.EMPTY_SCHEMA_DEFINITION : schemasDefinition;
    }

    protected SchemasDefinition getCurrentSchemasDefinitionPDFA_2_3ForNS(String nameSpace) {
        SchemasDefinition schemasDefinition = this.getCurrentSchemasDefinitionPDFA_2_3().get(nameSpace);
        return schemasDefinition == null ? SchemasDefinitionCreator.EMPTY_SCHEMA_DEFINITION : schemasDefinition;
    }
}

