/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.profiles.ProfileDetails;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;

@XmlRootElement(name="validationResult")
final class ValidationResultImpl
implements ValidationResult {
    private static final ValidationResultImpl DEFAULT = new ValidationResultImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlElement
    private final ProfileDetails profileDetails;
    @XmlAttribute
    private final int totalAssertions;
    @XmlElementWrapper
    @XmlElement(name="assertion")
    private final Set<TestAssertion> assertions;
    @XmlAttribute
    private final boolean isCompliant;
    private final ValidationProfile validationProfile;

    private ValidationResultImpl() {
        this(Profiles.defaultProfile(), Collections.emptySet(), false);
    }

    private ValidationResultImpl(ValidationProfile validationProfile, Set<TestAssertion> assertions, boolean isCompliant) {
        this(validationProfile, assertions, isCompliant, assertions.size());
    }

    private ValidationResultImpl(ValidationProfile validationProfile, Set<TestAssertion> assertions, boolean isCompliant, int totalAssertions) {
        this.flavour = validationProfile.getPDFAFlavour();
        this.assertions = new HashSet<TestAssertion>(assertions);
        this.isCompliant = isCompliant;
        this.totalAssertions = totalAssertions;
        this.profileDetails = validationProfile.getDetails();
        this.validationProfile = validationProfile;
    }

    @Override
    public boolean isCompliant() {
        return this.isCompliant;
    }

    @Override
    public PDFAFlavour getPDFAFlavour() {
        return this.flavour;
    }

    @Override
    public ProfileDetails getProfileDetails() {
        return this.profileDetails;
    }

    @Override
    public int getTotalAssertions() {
        return this.totalAssertions;
    }

    @Override
    public Set<TestAssertion> getTestAssertions() {
        return Collections.unmodifiableSet(this.assertions);
    }

    @Override
    public ValidationProfile getValidationProfile() {
        return this.validationProfile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assertions == null ? 0 : this.assertions.hashCode());
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + (this.isCompliant ? 1231 : 1237);
        result = 31 * result + this.totalAssertions;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        if (this.assertions == null) {
            if (other.getTestAssertions() != null) {
                return false;
            }
        } else {
            if (other.getTestAssertions() == null) {
                return false;
            }
            if (!this.assertions.equals(other.getTestAssertions())) {
                return false;
            }
        }
        if (this.flavour != other.getPDFAFlavour()) {
            return false;
        }
        if (this.isCompliant != other.isCompliant()) {
            return false;
        }
        return this.totalAssertions == other.getTotalAssertions();
    }

    public String toString() {
        return "ValidationResult [flavour=" + (Object)((Object)this.flavour) + ", totalAssertions=" + this.totalAssertions + ", assertions=" + this.assertions + ", isCompliant=" + this.isCompliant + "]";
    }

    static ValidationResultImpl defaultInstance() {
        return DEFAULT;
    }

    static ValidationResultImpl fromValues(ValidationProfile validationProfile, Set<TestAssertion> assertions, boolean isCompliant, int totalChecks) {
        return new ValidationResultImpl(validationProfile, assertions, isCompliant, totalChecks);
    }

    static ValidationResultImpl fromValidationResult(ValidationResult toConvert) {
        Set<TestAssertion> assertions = toConvert.getTestAssertions();
        return ValidationResultImpl.fromValues(toConvert.getValidationProfile(), assertions, toConvert.isCompliant(), toConvert.getTotalAssertions());
    }

    static ValidationResultImpl stripPassedTests(ValidationResult toStrip) {
        Set<TestAssertion> assertions = toStrip.getTestAssertions();
        return ValidationResultImpl.fromValues(toStrip.getValidationProfile(), ValidationResultImpl.stripPassedTests(assertions), toStrip.isCompliant(), toStrip.getTotalAssertions());
    }

    static Set<TestAssertion> stripPassedTests(Set<TestAssertion> toStrip) {
        HashSet<TestAssertion> strippedSet = new HashSet<TestAssertion>();
        for (TestAssertion test : toStrip) {
            if (test.getStatus() == TestAssertion.Status.PASSED) continue;
            strippedSet.add(test);
        }
        return strippedSet;
    }

    static class Adapter
    extends XmlAdapter<ValidationResultImpl, ValidationResult> {
        Adapter() {
        }

        @Override
        public ValidationResult unmarshal(ValidationResultImpl validationResultImpl) {
            return validationResultImpl;
        }

        @Override
        public ValidationResultImpl marshal(ValidationResult validationResult) {
            return (ValidationResultImpl)validationResult;
        }
    }
}

