/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cff.CFFCIDFontProgram;
import org.verapdf.pd.font.cff.CFFFileBaseParser;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.cff.CFFType1FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class CFFFontProgram
extends CFFFileBaseParser
implements FontProgram {
    private static final Logger LOGGER = Logger.getLogger(CFFFontProgram.class.getCanonicalName());
    private FontProgram font;
    private CMap externalCMap;
    private boolean isCIDFont = false;
    private boolean isFontParsed = false;
    private boolean isSubset;

    public CFFFontProgram(ASInputStream stream, CMap cMap, boolean isSubset) throws IOException {
        super(stream);
        this.externalCMap = cMap;
        this.isSubset = isSubset;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.isFontParsed) {
            this.isFontParsed = true;
            this.readHeader();
            this.readIndex();
            long topOffset = this.source.getOffset();
            CFFIndex top = this.readIndex();
            if (top.size() == 0) {
                LOGGER.log(Level.WARNING, "Error in cff font program parsing: top DICT INDEX is empty.");
                throw new IOException("Error in cff font program parsing: top DICT INDEX is empty.");
            }
            this.definedNames = this.readIndex();
            CFFIndex globalSubrs = this.readIndex();
            this.font = this.isCIDFont(top.get(0)) ? new CFFCIDFontProgram(this.source, this.definedNames, globalSubrs, topOffset + (long)top.getOffset(0) - 1L + (long)top.getOffsetShift(), topOffset + (long)top.getOffset(1) - 1L + (long)top.getOffsetShift(), this.externalCMap, this.isSubset) : new CFFType1FontProgram(this.source, this.definedNames, globalSubrs, topOffset + (long)top.getOffset(0) - 1L + (long)top.getOffsetShift(), topOffset + (long)top.getOffset(1) - 1L + (long)top.getOffsetShift(), this.externalCMap, this.isSubset);
            this.font.parseFont();
        }
    }

    private boolean isCIDFont(byte[] topDict) {
        try {
            int rosOffset;
            int supplementFirstByte = topDict[4] & 0xFF;
            if (supplementFirstByte < 247 && supplementFirstByte > 31) {
                rosOffset = 5;
            } else if (supplementFirstByte > 246 && supplementFirstByte < 255) {
                rosOffset = 6;
            } else if (supplementFirstByte == 28) {
                rosOffset = 7;
            } else if (supplementFirstByte == 29) {
                rosOffset = 9;
            } else {
                return this.isContainsROS(topDict);
            }
            if (topDict[rosOffset] == 12 && topDict[rosOffset + 1] == 30) {
                this.isCIDFont = true;
                return true;
            }
            return this.isContainsROS(topDict);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.isContainsROS(topDict);
        }
    }

    private boolean isContainsROS(byte[] topDict) {
        for (int rosOffset = 0; rosOffset < topDict.length - 2; ++rosOffset) {
            if (topDict[rosOffset] != 12 || topDict[rosOffset + 1] != 30) continue;
            LOGGER.log(Level.WARNING, "The Top DICT does not begin with ROS operator");
            this.isCIDFont = true;
            return true;
        }
        return false;
    }

    @Override
    public float getWidth(int code) {
        return this.font.getWidth(code);
    }

    @Override
    public float getWidth(String glyphName) {
        return this.font.getWidth(glyphName);
    }

    @Override
    public String getGlyphName(int code) {
        return this.font != null ? this.font.getGlyphName(code) : null;
    }

    public boolean isCIDFont() {
        return this.isCIDFont;
    }

    @Override
    public boolean containsCode(int code) {
        return this.font.containsCode(code);
    }

    @Override
    public boolean containsGlyph(String glyphName) {
        return this.font.containsGlyph(glyphName);
    }

    @Override
    public boolean containsCID(int cid) {
        return this.font.containsCID(cid);
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.font != null && this.font.isAttemptedParsing();
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.font != null && this.font.isSuccessfulParsing();
    }

    public List<Integer> getCIDList() {
        if (this.font instanceof CFFCIDFontProgram) {
            return ((CFFCIDFontProgram)this.font).getCIDList();
        }
        return Collections.emptyList();
    }

    public FontProgram getFont() {
        return this.font;
    }

    @Override
    public ASFileStreamCloser getFontProgramResource() {
        if (this.source instanceof ASMemoryInStream) {
            return null;
        }
        return new ASFileStreamCloser(this.source);
    }
}

