/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;

@XmlRootElement(name="validatorConfig")
final class ValidatorConfigImpl
implements ValidatorConfig {
    private static final ValidatorConfigImpl defaultConfig = new ValidatorConfigImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlAttribute
    private final PDFAFlavour defaultFlavour;
    @XmlAttribute
    private final boolean recordPasses;
    @XmlAttribute
    private final int maxFails;
    @XmlAttribute
    private final boolean debug;

    private ValidatorConfigImpl() {
        this(PDFAFlavour.NO_FLAVOUR, false, -1, false);
    }

    private ValidatorConfigImpl(PDFAFlavour flavour, boolean recordPasses, int maxFails, boolean debug) {
        this.flavour = flavour;
        this.defaultFlavour = PDFAFlavour.PDFA_1_B;
        this.recordPasses = recordPasses;
        this.maxFails = maxFails;
        this.debug = debug;
    }

    private ValidatorConfigImpl(PDFAFlavour flavour, PDFAFlavour defaultFlavour, boolean recordPasses, int maxFails, boolean debug) {
        this.flavour = flavour;
        this.defaultFlavour = defaultFlavour;
        this.recordPasses = recordPasses;
        this.maxFails = maxFails;
        this.debug = debug;
    }

    @Override
    public boolean isRecordPasses() {
        return this.recordPasses;
    }

    @Override
    public int getMaxFails() {
        return this.maxFails;
    }

    @Override
    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    @Override
    public PDFAFlavour getDefaultFlavour() {
        return this.defaultFlavour;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + this.maxFails;
        result = 31 * result + (this.recordPasses ? 1231 : 1237);
        result = 31 * result + (this.debug ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatorConfigImpl)) {
            return false;
        }
        ValidatorConfigImpl other = (ValidatorConfigImpl)obj;
        if (this.flavour != other.flavour) {
            return false;
        }
        if (this.maxFails != other.maxFails) {
            return false;
        }
        if (this.recordPasses != other.recordPasses) {
            return false;
        }
        return this.debug == other.debug;
    }

    public String toString() {
        return "ValidatorConfigImpl [recordPasses=" + this.recordPasses + ", maxFails=" + this.maxFails + ", flavour=" + (Object)((Object)this.flavour) + "]";
    }

    static ValidatorConfig defaultInstance() {
        return defaultConfig;
    }

    static ValidatorConfig fromValues(PDFAFlavour flavour, boolean recordPasses, int maxFails, boolean debug) {
        return new ValidatorConfigImpl(flavour, recordPasses, maxFails, debug);
    }

    static ValidatorConfig fromValues(PDFAFlavour flavour, PDFAFlavour defaultFlavour, boolean recordPasses, int maxFails, boolean debug) {
        return new ValidatorConfigImpl(flavour, defaultFlavour, recordPasses, maxFails, debug);
    }

    static class Adapter
    extends XmlAdapter<ValidatorConfigImpl, ValidatorConfig> {
        Adapter() {
        }

        @Override
        public ValidatorConfig unmarshal(ValidatorConfigImpl validationConfigImpl) {
            return validationConfigImpl;
        }

        @Override
        public ValidatorConfigImpl marshal(ValidatorConfig validationResult) {
            return (ValidatorConfigImpl)validationResult;
        }
    }
}

