/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.actions;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.pdlayer.PDMediaClip;

public class GFPDMediaClip
extends GFPDObject
implements PDMediaClip {
    public static final String MEDIA_CLIP_TYPE = "PDMediaClip";

    public GFPDMediaClip(org.verapdf.pd.actions.PDMediaClip simplePDObject) {
        super(simplePDObject, MEDIA_CLIP_TYPE);
    }

    @Override
    public String getCT() {
        return ((org.verapdf.pd.actions.PDMediaClip)this.simplePDObject).getContentType();
    }

    @Override
    public String getAlt() {
        List<String> list = ((org.verapdf.pd.actions.PDMediaClip)this.simplePDObject).getAlternateDescription();
        return list.stream().filter(Objects::nonNull).collect(Collectors.joining(""));
    }

    @Override
    public Boolean gethasCorrectAlt() {
        COSObject object = this.simplePDObject.getKey(ASAtom.ALT);
        if (object.getType() != COSObjType.COS_ARRAY) {
            return false;
        }
        COSArray array = (COSArray)object.getDirectBase();
        if (array.size() % 2 != 0) {
            return false;
        }
        for (int i = 0; i < array.size(); ++i) {
            COSObject elem = array.at(i);
            if (elem.getType() == COSObjType.COS_STRING && (i % 2 != 1 || !elem.getString().isEmpty())) continue;
            return false;
        }
        return true;
    }
}

