/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.verapdf.apps.ConfigManager;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.gui.ChooseFlavourRenderer;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;

class SettingsPanel
extends JPanel {
    private static final long serialVersionUID = -5688021756073449469L;
    private JButton okButton;
    boolean ok;
    JDialog dialog;
    private JTextField numberOfFailed;
    private JTextField numberOfFailedDisplay;
    private JCheckBox hidePassedRules;
    private JTextField fixMetadataPrefix;
    private PDFAFlavour currentDefaultFlavour;
    JTextField fixMetadataFolder;
    JFileChooser folderChooser;
    private JTextField profilesWikiPath;
    private static final Map<String, PDFAFlavour> FLAVOURS_MAP = new HashMap<String, PDFAFlavour>();
    private JComboBox<String> chooseDefaultFlavour;
    private static final char[] FORBIDDEN_SYMBOLS_IN_FILE_NAME = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '+', '\u0000', '%'};

    SettingsPanel(ConfigManager config) throws IOException {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(7, 2));
        panel.add(new JLabel("Include passed rules:"));
        this.hidePassedRules = new JCheckBox();
        panel.add(this.hidePassedRules);
        panel.add(new JLabel("Halt validation after failed checks:"));
        this.numberOfFailed = new JTextField();
        this.numberOfFailed.setTransferHandler(null);
        this.numberOfFailed.addKeyListener(SettingsPanel.getKeyAdapter(this.numberOfFailed, false));
        this.numberOfFailed.setToolTipText("1 to 999999 or empty for unlimited");
        JPanel panel1 = new JPanel();
        panel1.setLayout(null);
        this.numberOfFailed.setBounds(0, 0, 65, 23);
        panel1.add(this.numberOfFailed);
        panel.add(panel1);
        panel.add(new JLabel("Display failed checks for rule: "));
        this.numberOfFailedDisplay = new JTextField();
        this.numberOfFailedDisplay.setTransferHandler(null);
        this.numberOfFailedDisplay.addKeyListener(SettingsPanel.getKeyAdapter(this.numberOfFailedDisplay, true));
        this.numberOfFailedDisplay.setToolTipText("0 to 999999 or empty for unlimited");
        JPanel panel2 = new JPanel();
        panel2.setLayout(null);
        this.numberOfFailedDisplay.setBounds(0, 0, 65, 23);
        panel2.add(this.numberOfFailedDisplay);
        panel.add(panel2);
        panel.add(new JLabel("Save repaired files with prefix:"));
        this.fixMetadataPrefix = new JTextField(19);
        this.fixMetadataPrefix.setTransferHandler(null);
        panel.add(this.fixMetadataPrefix);
        panel.add(new JLabel("Save repaired files into the folder:"));
        File currentDir = new File(new File(".").getCanonicalPath());
        JButton choose2 = new JButton("Choose");
        this.folderChooser = new JFileChooser();
        this.folderChooser.setCurrentDirectory(currentDir);
        this.folderChooser.setFileSelectionMode(1);
        choose2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int resultChoose = SettingsPanel.this.folderChooser.showOpenDialog(SettingsPanel.this);
                if (resultChoose == 0) {
                    if (!SettingsPanel.this.folderChooser.getSelectedFile().isDirectory()) {
                        JOptionPane.showMessageDialog(SettingsPanel.this, "Error. Selected directory doesn't exist.", "Error", 0);
                    } else {
                        SettingsPanel.this.fixMetadataFolder.setText(SettingsPanel.this.folderChooser.getSelectedFile().getAbsolutePath());
                    }
                }
            }
        });
        this.fixMetadataFolder = new JTextField(19);
        this.fixMetadataFolder.setToolTipText("Select a folder for saving repaired files to. If not set then they'll be saved next to the original.");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BoxLayout(panel4, 0));
        panel4.add(this.fixMetadataFolder);
        panel4.add(choose2);
        panel.add(panel4);
        this.fixMetadataPrefix.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!SettingsPanel.isValidFileNameCharacter(e.getKeyChar())) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
            }
        });
        panel.add(new JLabel("Validation Profiles wiki root:"));
        this.profilesWikiPath = new JTextField(19);
        panel.add(this.profilesWikiPath);
        panel.add(new JLabel("Default flavour"));
        Vector availableFlavours = new Vector();
        TreeSet<String> sortedFlavours = new TreeSet<String>();
        for (PDFAFlavour flavour : Profiles.getVeraProfileDirectory().getPDFAFlavours()) {
            String flavourReadableText = CheckerPanel.getFlavourReadableText(flavour);
            sortedFlavours.add(flavourReadableText);
            FLAVOURS_MAP.put(flavourReadableText, flavour);
        }
        availableFlavours.addAll(sortedFlavours);
        this.chooseDefaultFlavour = new JComboBox(availableFlavours);
        this.chooseDefaultFlavour.setOpaque(true);
        ChooseFlavourRenderer renderer = new ChooseFlavourRenderer();
        this.chooseDefaultFlavour.setRenderer(renderer);
        PDFAFlavour fromConfig = config.createProcessorConfig().getValidatorConfig().getDefaultFlavour();
        String fromConfigDefaultFlavourText = CheckerPanel.getFlavourReadableText(fromConfig);
        if (availableFlavours.contains(fromConfigDefaultFlavourText)) {
            this.chooseDefaultFlavour.setSelectedItem(fromConfigDefaultFlavourText);
            this.currentDefaultFlavour = fromConfig;
        } else {
            this.chooseDefaultFlavour.setSelectedItem(CheckerPanel.getFlavourReadableText(PDFAFlavour.PDFA_1_B));
            this.currentDefaultFlavour = PDFAFlavour.PDFA_1_B;
        }
        panel.add(this.chooseDefaultFlavour);
        this.add((Component)panel, "Center");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String selectedItem = (String)SettingsPanel.this.chooseDefaultFlavour.getSelectedItem();
                SettingsPanel.this.currentDefaultFlavour = (PDFAFlavour)((Object)FLAVOURS_MAP.get(selectedItem));
                boolean isEverythingValid = true;
                Path mdPath = FileSystems.getDefault().getPath(SettingsPanel.this.fixMetadataFolder.getText(), new String[0]);
                if (!(mdPath != null && (mdPath.toString().isEmpty() || mdPath.toFile().isDirectory() && mdPath.toFile().canWrite()))) {
                    isEverythingValid = false;
                    JOptionPane.showMessageDialog(SettingsPanel.this, "Invalid path for saving fixed files.", "Invalid data", 1);
                }
                if (isEverythingValid) {
                    SettingsPanel.this.ok = true;
                    SettingsPanel.this.dialog.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SettingsPanel.this.dialog.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    boolean showDialog(Component parent, String title, ConfigManager settings) {
        this.ok = false;
        this.hidePassedRules.setSelected(settings.createProcessorConfig().getValidatorConfig().isRecordPasses());
        int numbOfFail = settings.createProcessorConfig().getValidatorConfig().getMaxFails();
        if (numbOfFail == -1) {
            this.numberOfFailed.setText("");
        } else {
            this.numberOfFailed.setText(String.valueOf(numbOfFail));
        }
        int numbOfFailDisp = settings.getApplicationConfig().getMaxFailsDisplayed();
        if (numbOfFailDisp == -1) {
            this.numberOfFailedDisplay.setText("");
        } else {
            this.numberOfFailedDisplay.setText(String.valueOf(numbOfFailDisp));
        }
        PDFAFlavour defaultFlavour = settings.createProcessorConfig().getValidatorConfig().getDefaultFlavour();
        String fromConfigDefaultFlavourText = CheckerPanel.getFlavourReadableText(defaultFlavour);
        this.chooseDefaultFlavour.setSelectedItem(fromConfigDefaultFlavourText);
        this.fixMetadataPrefix.setText(settings.createProcessorConfig().getFixerConfig().getFixesPrefix());
        this.fixMetadataFolder.setText(settings.getApplicationConfig().getFixesFolder());
        this.profilesWikiPath.setText(settings.getApplicationConfig().getWikiPath());
        Frame owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setResizable(false);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setTitle(title);
        }
        this.dialog.setLocation(150, 150);
        this.dialog.setVisible(true);
        return this.ok;
    }

    public PDFAFlavour getCurrentDefaultFlavour() {
        return this.currentDefaultFlavour;
    }

    private static KeyAdapter getKeyAdapter(final JTextField field, final boolean fromZero) {
        return new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (field.getText().length() == 6 && (field.getSelectedText() == null || field.getSelectedText().length() == 0) && c != '\b' && c != '\u007f') {
                    e.consume();
                } else if (c == '0' && (!fromZero && field.getText().length() == 0 || field.getText().startsWith("0"))) {
                    e.consume();
                } else if ((c < '0' || c > '9') && c != '\b' && c != '\u007f') {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (field.getText().startsWith("0")) {
                    field.setText(field.getText().replaceFirst("0*", ""));
                    if (field.getText().length() == 0) {
                        if (fromZero) {
                            field.setText("0");
                        } else {
                            field.setText("");
                        }
                    }
                }
                super.keyReleased(e);
            }
        };
    }

    boolean isDispPassedRules() {
        return this.hidePassedRules.isSelected();
    }

    int getFailedChecksNumber() {
        String str = this.numberOfFailed.getText();
        return str.length() > 0 ? Integer.parseInt(str) : -1;
    }

    int getFailedChecksDisplayNumber() {
        String str = this.numberOfFailedDisplay.getText();
        return str.length() > 0 ? Integer.parseInt(str) : -1;
    }

    Path getFixMetadataDirectory() {
        return FileSystems.getDefault().getPath(this.fixMetadataFolder.getText(), new String[0]);
    }

    String getFixMetadataPrefix() {
        return this.fixMetadataPrefix.getText();
    }

    String getProfilesWikiPath() {
        return this.profilesWikiPath.getText();
    }

    public static final boolean isValidFileNameCharacter(char c) {
        for (char ch : FORBIDDEN_SYMBOLS_IN_FILE_NAME) {
            if (ch != c) continue;
            return false;
        }
        return true;
    }
}

