/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.BaseValidator;
import org.verapdf.pdfa.validation.validators.FastFailValidator;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorConfigImpl;

public final class ValidatorFactory {
    private ValidatorFactory() {
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, boolean logPassedChecks) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return ValidatorFactory.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), logPassedChecks);
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, boolean logPassedChecks, int maxFailures) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return ValidatorFactory.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), logPassedChecks, maxFailures);
    }

    public static PDFAValidator createValidator(ValidationProfile profile) {
        return ValidatorFactory.createValidator(profile, false);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, boolean logPassedChecks) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        return new BaseValidator(profile, logPassedChecks);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, int maxFailures) {
        return ValidatorFactory.createValidator(profile, false, maxFailures);
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, int maxFailures) {
        return ValidatorFactory.createValidator(flavour, false, maxFailures);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, boolean logPassedChecks, int maxFailures) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        if (maxFailures > 0) {
            return new FastFailValidator(profile, logPassedChecks, maxFailures);
        }
        return ValidatorFactory.createValidator(profile, logPassedChecks);
    }

    public static ValidatorConfig defaultConfig() {
        return ValidatorConfigImpl.defaultInstance();
    }

    public static ValidatorConfig createConfig(PDFAFlavour flavour, boolean recordPasses, int maxFails, boolean debug) {
        return ValidatorConfigImpl.fromValues(flavour, recordPasses, maxFails, debug);
    }

    public static ValidatorConfig createConfig(PDFAFlavour flavour, PDFAFlavour defaultFlavour, boolean recordPasses, int maxFails, boolean debug) {
        return ValidatorConfigImpl.fromValues(flavour, defaultFlavour, recordPasses, maxFails, debug);
    }

    public static ValidatorConfig createConfig(InputStream source) throws JAXBException {
        return (ValidatorConfig)XmlSerialiser.typeFromXml(ValidatorConfigImpl.class, source);
    }

    public static String configToXml(ValidatorConfig source) throws JAXBException {
        return XmlSerialiser.toXml(source, true, false);
    }

    public static void configToXml(ValidatorConfig source, OutputStream dest) throws JAXBException {
        XmlSerialiser.toXml(source, dest, true, false);
    }
}

