/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.cli.CliConstants;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.core.VeraPDFException;
import org.verapdf.policy.PolicyChecker;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.app.ConfigManager;
import org.verapdf.processor.app.VeraAppConfig;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.ItemDetails;

final class VeraPdfCliProcessor
implements Closeable {
    private static final Logger logger = Logger.getLogger(VeraPdfCliProcessor.class.getCanonicalName());
    private final ConfigManager configManager;
    private final ProcessorConfig processorConfig;
    private final VeraAppConfig appConfig;
    private final boolean isPolicy;
    private final boolean isRecursive;
    private final boolean isServerMode;
    private final File tempMrrFile;
    private final File policyFile;
    private boolean isStdOut = true;
    private OutputStream os;
    private File tempFile;

    private VeraPdfCliProcessor(VeraCliArgParser args, ConfigManager configManager) throws VeraPDFException {
        this.configManager = configManager;
        this.isPolicy = args.isPolicy();
        this.isRecursive = args.isRecurse();
        this.isServerMode = args.isServerMode();
        try {
            this.tempMrrFile = this.isPolicy ? File.createTempFile("mrr", "veraPDF") : null;
        }
        catch (IOException excep) {
            throw new VeraPDFException("Failed to create temporary MRR file", excep);
        }
        this.policyFile = args.getPolicyFile();
        this.appConfig = args.appConfig(configManager.getApplicationConfig());
        this.processorConfig = args.processorConfig(this.appConfig.getProcessType(), this.configManager.getPluginsCollectionConfig());
    }

    VeraAppConfig getConfig() {
        return this.appConfig;
    }

    ProcessorConfig getProcessorConfig() {
        return this.processorConfig;
    }

    CliConstants.ExitCodes processPaths(List<String> pdfPaths, boolean nonPdfExt) throws VeraPDFException {
        CliConstants.ExitCodes retStatus = CliConstants.ExitCodes.VALID;
        if (this.isServerMode) {
            try {
                this.tempFile = Files.createTempFile("tempReport", ".xml", new FileAttribute[0]).toFile();
                this.os = new FileOutputStream(this.tempFile);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can't create temp file", e);
            }
        } else {
            this.os = System.out;
        }
        retStatus = pdfPaths.isEmpty() && !this.isServerMode ? this.processStdIn() : this.processFilePaths(pdfPaths, nonPdfExt);
        if (this.isPolicy) {
            this.applyPolicy();
        }
        return retStatus;
    }

    static VeraPdfCliProcessor createProcessorFromArgs(VeraCliArgParser args, ConfigManager config) throws VeraPDFException {
        return new VeraPdfCliProcessor(args, config);
    }

    private CliConstants.ExitCodes processStdIn() {
        try {
            if (System.in.available() == 0) {
                return CliConstants.ExitCodes.VALID;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "STDIN is not available", e);
        }
        ItemDetails item = ItemDetails.fromValues("STDIN");
        return this.processStream(item, System.in);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private CliConstants.ExitCodes processFilePaths(List<String> paths, boolean nonPdfExt) {
        ArrayList<File> toFilter = new ArrayList<File>();
        for (String path : paths) {
            toFilter.add(new File(path));
        }
        List<File> toProcess = ApplicationUtils.filterPdfFiles(toFilter, this.isRecursive, nonPdfExt);
        if (toProcess.isEmpty()) {
            logger.log(Level.SEVERE, "There are no files to process.");
            return CliConstants.ExitCodes.NO_FILES;
        }
        try (BatchProcessor processor = ProcessorFactory.fileBatchProcessor(this.processorConfig);){
            CliConstants.ExitCodes exitCodes;
            block17: {
                OutputStream reportStream = this.getReportStream();
                try {
                    BatchSummary summary = processor.process(toProcess, ProcessorFactory.getHandler(this.appConfig.getFormat(), this.appConfig.isVerbose(), reportStream, this.processorConfig.getValidatorConfig().isRecordPasses(), this.appConfig.getWikiPath()));
                    reportStream.flush();
                    exitCodes = VeraPdfCliProcessor.exitStatusFromSummary(summary);
                    if (reportStream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (reportStream != null) {
                        try {
                            reportStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reportStream.close();
            }
            return exitCodes;
        }
        catch (VeraPDFException excep) {
            String message = "VeraPDFException raised while processing batch";
            System.err.println(message);
            logger.log(Level.SEVERE, message, excep);
            return CliConstants.ExitCodes.VERAPDF_EXCEPTION;
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing MRR temp file.", excep);
            return CliConstants.ExitCodes.IO_EXCEPTION;
        }
    }

    private static CliConstants.ExitCodes exitStatusFromSummary(BatchSummary summary) {
        if (summary.getFailedParsingJobs() > 0) {
            return CliConstants.ExitCodes.FAILED_PARSING;
        }
        if (summary.getFailedEncryptedJobs() > 0) {
            return CliConstants.ExitCodes.ENCRYPTED_FILES;
        }
        if (summary.getValidationSummary().getNonCompliantPdfaCount() > 0) {
            return CliConstants.ExitCodes.INVALID;
        }
        if (summary.getOutOfMemory() > 0) {
            return CliConstants.ExitCodes.OOM;
        }
        if (summary.getVeraExceptions() > 0) {
            return CliConstants.ExitCodes.VERAPDF_EXCEPTION;
        }
        return CliConstants.ExitCodes.VALID;
    }

    private CliConstants.ExitCodes processStream(ItemDetails item, InputStream toProcess) {
        CliConstants.ExitCodes retVal = CliConstants.ExitCodes.VALID;
        try (ItemProcessor processor = ProcessorFactory.createProcessor(this.processorConfig);){
            ProcessorResult result = processor.process(item, toProcess);
            OutputStream outputReportStream = this.getReportStream();
            try {
                BatchProcessingHandler handler = ProcessorFactory.getHandler(this.appConfig.getFormat(), this.appConfig.isVerbose(), outputReportStream, this.processorConfig.getValidatorConfig().isRecordPasses());
                if (result.isPdf() && !result.isEncryptedPdf()) {
                    ProcessorFactory.writeSingleResultReport(result, handler, this.processorConfig);
                    if (!result.getValidationResult().isCompliant()) {
                        retVal = CliConstants.ExitCodes.INVALID;
                    }
                } else {
                    String message = String.format(result.isPdf() ? "%s is an encrypted PDF document." : "%s is not a valid PDF document.", item.getName());
                    outputReportStream.write(message.getBytes());
                    retVal = result.isPdf() ? CliConstants.ExitCodes.ENCRYPTED_FILES : CliConstants.ExitCodes.FAILED_PARSING;
                }
            }
            catch (IOException excep) {
                logger.log(Level.SEVERE, "JAXBException raised when marshalling report.", excep);
                retVal = CliConstants.ExitCodes.JAXB_EXCEPTION;
            }
            catch (VeraPDFException e) {
                logger.log(Level.SEVERE, "STDIN is not available", e);
            }
            if (!this.isStdOut) {
                try {
                    outputReportStream.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Cannot close the report file.", ex);
                }
            }
        }
        catch (IOException excep) {
            logger.log(Level.FINER, "IOException raised when closing ItemProcessor", excep);
        }
        return retVal;
    }

    private OutputStream getReportStream() {
        if (this.isPolicy) {
            if (this.tempMrrFile == null) {
                throw new IllegalStateException("Policy enabled BUT no temp destination");
            }
            try {
                this.isStdOut = false;
                return new FileOutputStream(this.tempMrrFile);
            }
            catch (FileNotFoundException excep) {
                throw new IllegalStateException("Policy enabled BUT no temp destination", excep);
            }
        }
        return this.os;
    }

    private void applyPolicy() throws VeraPDFException {
        File tempPolicyResult;
        try {
            tempPolicyResult = File.createTempFile("policyResult", "veraPDF");
        }
        catch (IOException excep) {
            throw new VeraPDFException("Could not create temporary policy result file.", excep);
        }
        try (FileInputStream mrrIs = new FileInputStream(this.tempMrrFile);
             FileOutputStream policyResultOs = new FileOutputStream(tempPolicyResult);){
            PolicyChecker.applyPolicy(this.policyFile, mrrIs, policyResultOs);
            PolicyChecker.insertPolicyReport(tempPolicyResult, this.tempMrrFile, this.os);
        }
        catch (FileNotFoundException excep) {
            throw new VeraPDFException("Could not find temporary policy result file.", excep);
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing temporary policy file.", excep);
        }
        if (!tempPolicyResult.delete()) {
            tempPolicyResult.deleteOnExit();
        }
    }

    @Override
    public void close() {
        if (this.tempMrrFile != null && !this.tempMrrFile.delete()) {
            this.tempMrrFile.deleteOnExit();
        }
    }

    public File getTempFile() {
        return this.tempFile;
    }
}

