/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.verapdf.core.Directory;
import org.verapdf.core.MapBackedDirectory;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.ProfileDirectory;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.profiles.ValidationProfileImpl;

final class ProfileDirectoryImpl
implements ProfileDirectory {
    private static final String PROFILE_RESOURCE_ROOT = "org/verapdf/pdfa/validation/";
    private static final String XML_SUFFIX = ".xml";
    private static final ProfileDirectoryImpl DEFAULT = ProfileDirectoryImpl.makeVeraProfileDir();
    private final Directory<PDFAFlavour, ValidationProfile> profileDir;
    private final Directory<String, PDFAFlavour> flavourDir;

    private ProfileDirectoryImpl(Set<ValidationProfile> profileSet) {
        this(ProfileDirectoryImpl.profileMapFromSet(profileSet));
    }

    private ProfileDirectoryImpl(Map<PDFAFlavour, ValidationProfile> profileMap) {
        this.profileDir = new MapBackedDirectory<PDFAFlavour, ValidationProfile>(profileMap);
        this.flavourDir = new MapBackedDirectory<String, PDFAFlavour>(ProfileDirectoryImpl.flavourMapFromSet(profileMap.keySet()));
    }

    @Override
    public Set<String> getValidationProfileIds() {
        return Collections.unmodifiableSet(this.flavourDir.getKeys());
    }

    @Override
    public Set<PDFAFlavour> getPDFAFlavours() {
        return this.profileDir.getKeys();
    }

    @Override
    public ValidationProfile getValidationProfileById(String profileID) {
        if (profileID == null) {
            throw new IllegalArgumentException("Parameter profileID cannot be null");
        }
        PDFAFlavour flavour = this.flavourDir.getItem(profileID);
        if (flavour == null) {
            throw new NoSuchElementException("PDFAFlavour " + (Object)((Object)flavour) + " is not supported by this directory.");
        }
        return this.getValidationProfileByFlavour(flavour);
    }

    @Override
    public ValidationProfile getValidationProfileByFlavour(PDFAFlavour flavour) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter flavour cannot be null");
        }
        ValidationProfile profile = this.profileDir.getItem(flavour);
        if (profile == null) {
            throw new NoSuchElementException("PDFAFlavour " + (Object)((Object)flavour) + " is not supported by this directory.");
        }
        return profile;
    }

    @Override
    public Set<ValidationProfile> getValidationProfiles() {
        return Collections.unmodifiableSet(new HashSet<ValidationProfile>(this.profileDir.getItems()));
    }

    static ProfileDirectoryImpl getVeraProfileDirectory() {
        return DEFAULT;
    }

    static ProfileDirectoryImpl fromProfileSet(Set<ValidationProfile> profiles) {
        return new ProfileDirectoryImpl(profiles);
    }

    static Map<PDFAFlavour, ValidationProfile> profileMapFromSet(Set<ValidationProfile> profileSet) {
        HashMap<PDFAFlavour, ValidationProfile> profileMap = new HashMap<PDFAFlavour, ValidationProfile>();
        for (ValidationProfile profile : profileSet) {
            profileMap.put(profile.getPDFAFlavour(), profile);
        }
        return Collections.unmodifiableMap(profileMap);
    }

    static Map<String, PDFAFlavour> flavourMapFromSet(Set<PDFAFlavour> flavours) {
        HashMap<String, PDFAFlavour> flavourMap = new HashMap<String, PDFAFlavour>();
        for (PDFAFlavour flavour : flavours) {
            flavourMap.put(flavour.getId(), flavour);
        }
        return Collections.unmodifiableMap(flavourMap);
    }

    private static ProfileDirectoryImpl makeVeraProfileDir() {
        HashSet<ValidationProfile> profiles = new HashSet<ValidationProfile>();
        for (PDFAFlavour flavour : PDFAFlavour.values()) {
            String profilePath = ProfileDirectoryImpl.getProfilePath(flavour);
            try (InputStream is = ValidationProfileImpl.class.getClassLoader().getResourceAsStream(profilePath);){
                if (is == null) continue;
                profiles.add(Profiles.profileFromXml(is));
            }
            catch (IOException | JAXBException e) {
                e.printStackTrace();
            }
        }
        return ProfileDirectoryImpl.fromProfileSet(profiles);
    }

    private static String getProfilePath(PDFAFlavour flavour) {
        StringBuilder profilePath = new StringBuilder();
        profilePath.append(PROFILE_RESOURCE_ROOT).append(flavour.getPart().getFamily().getFamily().replace("/", "")).append("-").append(flavour.getPart().getPartNumber()).append(flavour.getLevel().getCode().toUpperCase());
        if (flavour == PDFAFlavour.PDFUA_2) {
            profilePath.append("-").append("ISO32005");
        }
        profilePath.append(XML_SUFFIX);
        return profilePath.toString();
    }
}

