/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.features.objects.InfoDictFeaturesObjectAdapter;
import org.verapdf.tools.TypeConverter;

public class GFInfoDictFeaturesObjectAdapter
implements InfoDictFeaturesObjectAdapter {
    private static final ASAtom[] predefinedKeys = new ASAtom[]{ASAtom.TITLE, ASAtom.AUTHOR, ASAtom.SUBJECT, ASAtom.KEYWORDS, ASAtom.CREATOR, ASAtom.PRODUCER, ASAtom.CREATION_DATE, ASAtom.MOD_DATE, ASAtom.TRAPPED};
    private COSObject info;

    public GFInfoDictFeaturesObjectAdapter(COSObject info) {
        this.info = info;
    }

    @Override
    public String getTitle() {
        return this.getStringKey(ASAtom.TITLE);
    }

    @Override
    public String getAuthor() {
        return this.getStringKey(ASAtom.AUTHOR);
    }

    @Override
    public String getSubject() {
        return this.getStringKey(ASAtom.SUBJECT);
    }

    @Override
    public String getKeywords() {
        return this.getStringKey(ASAtom.KEYWORDS);
    }

    @Override
    public String getCreator() {
        return this.getStringKey(ASAtom.CREATOR);
    }

    @Override
    public String getProducer() {
        return this.getStringKey(ASAtom.PRODUCER);
    }

    @Override
    public Calendar getCreationDate() {
        return this.getCalendarKey(ASAtom.CREATION_DATE);
    }

    @Override
    public Calendar getModDate() {
        return this.getCalendarKey(ASAtom.MOD_DATE);
    }

    @Override
    public String getTrapped() {
        return this.getNameKey(ASAtom.TRAPPED);
    }

    @Override
    public Map<String, String> getCustomValues() {
        if (this.info != null && this.info.getType() == COSObjType.COS_DICT) {
            TreeMap<String, String> res = new TreeMap<String, String>();
            TreeSet<ASAtom> keys = new TreeSet<ASAtom>(this.info.getKeySet());
            keys.removeAll(Arrays.asList(predefinedKeys));
            for (ASAtom key : keys) {
                res.put(key.getValue(), key == ASAtom.TRAPPED ? this.info.getNameKeyStringValue(key) : this.info.getStringKey(key));
            }
            return Collections.unmodifiableMap(res);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.info != null && !this.info.empty();
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private String getStringKey(ASAtom key) {
        if (this.info != null && this.info.getType() == COSObjType.COS_DICT) {
            return this.info.getStringKey(key);
        }
        return null;
    }

    private Calendar getCalendarKey(ASAtom key) {
        if (this.info != null && this.info.getType() == COSObjType.COS_DICT) {
            String date = this.info.getStringKey(key);
            return TypeConverter.parseDate(date);
        }
        return null;
    }

    private String getNameKey(ASAtom key) {
        if (this.info != null && this.info.getType() == COSObjType.COS_DICT) {
            return this.info.getNameKeyStringValue(key);
        }
        return null;
    }
}

