/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.COSParser;

public class SignatureParser
extends COSParser {
    private static final Logger LOGGER = Logger.getLogger(SignatureParser.class.getCanonicalName());
    private static final byte[] EOF_STRING = "%%EOF".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] STREAM_STRING = "stream".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ENDSTREAM_STRING = "endstream".getBytes(StandardCharsets.ISO_8859_1);
    private boolean isStream = false;
    private long[] byteRange = new long[4];
    private int floatingBytesNumber = 0;
    private boolean isStreamEnd = true;
    private COSDocument document;

    public SignatureParser(SeekableInputStream stream, COSDocument document) throws IOException {
        super(stream);
        this.document = document;
    }

    private void parseDictionary() throws IOException {
        this.skipSpaces();
        this.skipExpectedCharacter('<');
        this.skipExpectedCharacter('<');
        this.skipSpaces();
        boolean done = false;
        while (!done) {
            this.skipSpaces();
            char c = (char)this.source.peek();
            if (c == '>') {
                done = true;
                continue;
            }
            if (!this.parseSignatureNameValuePair()) continue;
            done = true;
        }
    }

    private void passCOSDictionaryValue() throws IOException {
        long numOffset = this.source.getOffset();
        COSObject number = this.nextObject();
        this.skipSpaces();
        if (!this.isDigit()) {
            return;
        }
        COSObject generationNumber = this.nextObject();
        this.skipSpaces();
        this.skipExpectedCharacter('R');
        if (number.getType() != COSObjType.COS_INTEGER) {
            throw new IOException(this.getErrorMessage("expected number but got" + (Object)((Object)number.getType()), numOffset));
        }
        if (generationNumber.getType() != COSObjType.COS_INTEGER) {
            throw new IOException(this.getErrorMessage("expected number but got" + (Object)((Object)generationNumber.getType()), numOffset));
        }
    }

    public long[] getByteRangeBySignatureOffset(long signatureOffset) throws IOException {
        this.source.seek(signatureOffset);
        this.skipID();
        this.byteRange[0] = 0L;
        this.parseDictionary();
        this.byteRange[3] = this.getOffsetOfNextEOF(this.getOffsetOfNextXRef(this.byteRange[2])) - this.byteRange[2];
        return this.byteRange;
    }

    public int getFloatingBytesNumberForLastByteRangeObtained() {
        return this.floatingBytesNumber;
    }

    public boolean isStreamEnd() {
        return this.isStreamEnd;
    }

    private boolean parseSignatureNameValuePair() throws IOException {
        COSObject key = this.getName();
        if (key.getType() != COSObjType.COS_NAME) {
            LOGGER.log(Level.FINE, this.getErrorMessage("Invalid signature dictionary"));
            return false;
        }
        if (key.getName() != ASAtom.CONTENTS) {
            this.passCOSDictionaryValue();
            return false;
        }
        this.parseSignatureValue();
        return true;
    }

    private void parseSignatureValue() throws IOException {
        this.skipSpaces();
        long numOffset1 = this.source.getOffset();
        COSObject number = this.nextObject();
        long numOffset2 = this.source.getOffset();
        this.skipSpaces();
        if (!this.isDigit()) {
            this.byteRange[1] = numOffset1;
            this.byteRange[2] = numOffset2;
            return;
        }
        long genOffset = this.source.getOffset();
        COSObject generationNumber = this.nextObject();
        this.skipSpaces();
        int c = this.source.read();
        if (c == 82) {
            if (number.getType() != COSObjType.COS_INTEGER) {
                throw new IOException(this.getErrorMessage("expected number but got" + (Object)((Object)number.getType()), numOffset1));
            }
            if (generationNumber.getType() != COSObjType.COS_INTEGER) {
                throw new IOException(this.getErrorMessage("expected number but got" + (Object)((Object)generationNumber.getType()), genOffset));
            }
            COSKey key = new COSKey(number.getInteger().intValue(), generationNumber.getInteger().intValue());
            long keyOffset = this.document.getOffset(key);
            this.source.seek(keyOffset + this.document.getHeader().getHeaderOffset());
            this.parseSignatureValue();
        }
        if (c != 111) {
            throw new IOException(this.getErrorMessage("\"R\" or \"obj\" expected, but '" + (char)c + "' found"));
        }
        this.skipExpectedCharacter('b');
        this.skipExpectedCharacter('j');
        this.skipSpaces();
        numOffset1 = this.source.getOffset();
        this.nextObject();
        numOffset2 = this.source.getOffset();
        this.byteRange[1] = numOffset1;
        this.byteRange[2] = numOffset2;
    }

    private long getOffsetOfNextXRef(long currentOffset) {
        return this.document.getStartXRefs().stream().filter(offset -> offset > currentOffset).findFirst().orElse(currentOffset);
    }

    private long getOffsetOfNextEOF(long currentOffset) throws IOException {
        byte[] buffer = new byte[EOF_STRING.length];
        this.source.seek(currentOffset + this.document.getHeader().getHeaderOffset());
        this.source.read(buffer);
        this.source.unread(buffer.length - 1);
        this.isStream = false;
        while (this.isStream || !this.isEOFFound(buffer)) {
            byte[] streamCheck = this.isStream ? ENDSTREAM_STRING : STREAM_STRING;
            byte[] streamCheckBuff = new byte[streamCheck.length];
            int unreadLength = this.source.read(streamCheckBuff);
            if (Arrays.equals(streamCheck, streamCheckBuff)) {
                this.isStream = !this.isStream;
                System.arraycopy(streamCheckBuff, 0, buffer, 0, EOF_STRING.length);
                unreadLength = -1;
            } else {
                this.source.unread(unreadLength);
                this.source.read(buffer);
                unreadLength = buffer.length - 1;
            }
            if (this.source.isEOF()) {
                this.source.seek(currentOffset + this.document.getHeader().getHeaderOffset());
                return this.source.getStreamLength();
            }
            if (unreadLength <= 0) continue;
            this.source.unread(unreadLength);
        }
        long result = this.source.getOffset() - 1L + (long)buffer.length;
        this.source.skip(EOF_STRING.length - 1);
        this.floatingBytesNumber = 0;
        this.isStreamEnd = false;
        int nextByte = this.source.read();
        if (SignatureParser.isLF(nextByte)) {
            ++result;
            ++this.floatingBytesNumber;
            nextByte = this.source.peek();
        } else if (SignatureParser.isCR(nextByte)) {
            ++result;
            ++this.floatingBytesNumber;
            nextByte = this.source.read();
            if (SignatureParser.isLF(nextByte)) {
                ++result;
                ++this.floatingBytesNumber;
                nextByte = this.source.peek();
            }
        }
        if (nextByte == -1) {
            this.isStreamEnd = true;
        }
        this.source.seek(currentOffset + this.document.getHeader().getHeaderOffset());
        return result;
    }

    private boolean isEOFFound(byte[] buffer) throws IOException {
        if (!Arrays.equals(buffer, EOF_STRING)) {
            return false;
        }
        long pointer = this.source.getOffset();
        this.source.unread(2);
        int byteBeforeEOF = this.source.peek();
        while (!SignatureParser.isLF(byteBeforeEOF)) {
            this.source.unread();
            byteBeforeEOF = this.source.peek();
            if (byteBeforeEOF == 32) continue;
            this.source.seek(pointer);
            return false;
        }
        this.source.seek(pointer);
        return true;
    }

    private void skipID() throws IOException {
        this.nextObject();
        this.objects.clear();
        this.flag = true;
    }
}

