/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.factory.operators.OperatorFactory;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDResources;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.parser.PDFStreamParser;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.tools.StaticResources;

public class GFPDContentStream
extends GFPDObject
implements PDContentStream {
    private static final Logger LOGGER = Logger.getLogger(GFPDContentStream.class.getCanonicalName());
    public static final String CONTENT_STREAM_TYPE = "PDContentStream";
    public static final String OPERATORS = "operators";
    private static final String RESOURCES = "resources";
    private PDResourcesHandler resourcesHandler;
    protected List<Operator> operators = null;
    private boolean containsTransparency = false;
    private final GraphicState inheritedGraphicState;
    private final StructureElementAccessObject structureElementAccessObject;
    protected COSObject parentStructElem;
    protected String parentsTags;

    public GFPDContentStream(org.verapdf.pd.PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject) {
        this(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, CONTENT_STREAM_TYPE);
    }

    public GFPDContentStream(org.verapdf.pd.PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, COSObject parentStructElem, String parentsTags) {
        this(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, parentStructElem, parentsTags, CONTENT_STREAM_TYPE);
    }

    public GFPDContentStream(org.verapdf.pd.PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, String type) {
        super(contentStream, type);
        this.resourcesHandler = resourcesHandler;
        this.inheritedGraphicState = inheritedGraphicState;
        this.structureElementAccessObject = structureElementAccessObject;
        this.parentsTags = "";
    }

    public GFPDContentStream(org.verapdf.pd.PDContentStream contentStream, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject, COSObject parentStructElem, String parentsTags, String type) {
        this(contentStream, resourcesHandler, inheritedGraphicState, structureElementAccessObject, type);
        this.parentStructElem = this.getParentStructureElem(structureElementAccessObject);
        if (this.parentStructElem == null) {
            this.parentStructElem = parentStructElem;
        }
        this.parentsTags = parentsTags;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "operators": {
                return this.getOperators();
            }
            case "resources": {
                return this.getResources();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Operator> getOperators() {
        if (this.operators == null) {
            this.parseOperators();
        }
        return this.operators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseOperators() {
        block19: {
            if (this.contentStream == null) {
                this.operators = Collections.emptyList();
            } else {
                try {
                    COSObject contentStream = this.contentStream.getContents();
                    if (contentStream.getType() == COSObjType.COS_STREAM || contentStream.getType() == COSObjType.COS_ARRAY) {
                        COSKey key = contentStream.getObjectKey();
                        if (key != null) {
                            if (StaticContainers.getTransparencyVisitedContentStreams().contains(key)) {
                                LOGGER.log(Level.FINE, "Parsing content stream loop");
                                StaticContainers.setValidPDF(false);
                                this.containsTransparency = false;
                                this.operators = Collections.emptyList();
                                return;
                            }
                            StaticContainers.getTransparencyVisitedContentStreams().push(key);
                        }
                        try (ASInputStream opStream = contentStream.getDirectBase().getData(COSStream.FilterFlags.DECODE);){
                            PDFStreamParser streamParser = new PDFStreamParser(opStream);
                            try {
                                streamParser.parseTokens();
                                OperatorFactory operatorFactory = new OperatorFactory();
                                List<Operator> result = operatorFactory.operatorsFromTokens(streamParser.getTokens(), this.resourcesHandler, this.inheritedGraphicState, this.structureElementAccessObject, this.parentStructElem, this.parentsTags);
                                this.containsTransparency = operatorFactory.isLastParsedContainsTransparency();
                                this.operators = Collections.unmodifiableList(result);
                            }
                            finally {
                                streamParser.close();
                                if (StaticResources.getDocument() != null && StaticResources.getDocument().getDocument() != null) {
                                    StaticResources.getDocument().getDocument().getResourceHandler().addAll(streamParser.getImageDataStreams());
                                }
                            }
                        }
                        if (key != null && StaticContainers.getTransparencyVisitedContentStreams().peek().equals(key)) {
                            StaticContainers.getTransparencyVisitedContentStreams().pop();
                        }
                        break block19;
                    }
                    this.operators = Collections.emptyList();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error while parsing content stream. " + e.getMessage(), e);
                    StaticContainers.setValidPDF(false);
                    this.operators = Collections.emptyList();
                }
            }
        }
    }

    @Override
    public String getundefinedResourceNames() {
        return this.resourcesHandler.getUndefinedResourceNames().stream().map(ASAtom::getValue).collect(Collectors.joining(","));
    }

    @Override
    public String getinheritedResourceNames() {
        return this.resourcesHandler.getInheritedResourceNames().stream().map(ASAtom::getValue).collect(Collectors.joining(","));
    }

    public boolean isContainsTransparency() {
        if (this.operators == null) {
            this.parseOperators();
        }
        return this.containsTransparency;
    }

    private COSObject getParentStructureElem(StructureElementAccessObject structureElementAccessObject) {
        PDStructTreeRoot structTreeRoot = StaticResources.getDocument().getStructTreeRoot();
        if (structTreeRoot != null) {
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : structureElementAccessObject.getStructureElement(parentTreeRoot, null);
            if (structureElement != null && !structureElement.empty()) {
                return structureElement;
            }
        }
        return null;
    }

    private List<org.verapdf.model.pdlayer.PDResources> getResources() {
        ArrayList<org.verapdf.model.pdlayer.PDResources> result = new ArrayList<org.verapdf.model.pdlayer.PDResources>(1);
        PDResources resources = this.resourcesHandler.getObjectResources();
        if (resources != null) {
            result.add(new GFPDResources(resources));
        }
        return result;
    }
}

