/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDictionary;

public class COSPredictorDecode
extends ASBufferedInFilter {
    private static final byte PREDICTOR_DEFAULT = 1;
    private static final int COLORS_DEFAULT = 1;
    private static final int BITS_PER_COMPONENT_DEFAULT = 8;
    private static final int COLUMNS_DEFAULT = 1;
    private int bitsPerComponent;
    private int bytesPerChar;
    private int lineLength;
    private byte predictor;
    private byte[] previousLine = null;
    private boolean streamEnded = false;

    public COSPredictorDecode(ASInputStream stream, COSDictionary decodeParams) throws IOException {
        super(stream);
        this.initializePredictorArguments(COSPredictorDecode.predictorFromParams(decodeParams), COSPredictorDecode.colorsFromParams(decodeParams), COSPredictorDecode.bitsFromParams(decodeParams), COSPredictorDecode.columnsFromParams(decodeParams));
    }

    private void initializePredictorArguments(byte predictor, int colors, int bitsPerComponent, int columns) {
        this.predictor = predictor;
        this.bitsPerComponent = bitsPerComponent;
        int bitsPerChar = colors * bitsPerComponent;
        this.bytesPerChar = (bitsPerChar + 7) / 8;
        this.lineLength = (columns * bitsPerChar + 7) / 8;
        if (this.previousLine == null) {
            this.previousLine = new byte[this.lineLength];
        }
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        if (this.streamEnded) {
            return -1;
        }
        if (this.bufferSize() == 0 && this.feedBuffer(this.getBufferCapacity()) == -1) {
            this.streamEnded = true;
        }
        if (this.predictor == 1) {
            int popped = this.bufferPopArray(buffer, size);
            if (this.bufferSize() == 0 && this.feedBuffer(this.getBufferCapacity()) == -1) {
                this.streamEnded = true;
            }
            return popped;
        }
        int outputPointer = 0;
        byte linePredictor = this.predictor;
        byte[] currentLine = new byte[this.lineLength];
        while (!this.streamEnded) {
            int read;
            if (this.predictor >= 10) {
                if (this.bufferSize() == 0 && this.feedBuffer(this.getBufferCapacity()) == -1) {
                    this.streamEnded = true;
                    break;
                }
                linePredictor = this.bufferPop();
                linePredictor = (byte)(linePredictor + 10);
            }
            if ((read = this.bufferPopArray(currentLine, this.lineLength)) != this.lineLength) {
                if (this.feedBuffer(this.getBufferCapacity()) == -1) {
                    this.streamEnded = true;
                    break;
                }
                byte[] extraBytes = new byte[this.lineLength - read];
                int readAgain = this.bufferPopArray(extraBytes, extraBytes.length);
                if (readAgain != extraBytes.length) {
                    this.streamEnded = true;
                    break;
                }
                System.arraycopy(extraBytes, 0, currentLine, read, readAgain);
            }
            switch (linePredictor) {
                case 2: {
                    int left;
                    int value;
                    if (this.bitsPerComponent == 16) {
                        for (int i = 0; i < this.lineLength; i += 2) {
                            value = (currentLine[i] << 8) + currentLine[i + 1];
                            left = i - this.bytesPerChar >= 0 ? (currentLine[i - this.bytesPerChar] << 8) + currentLine[i - this.bytesPerChar + 1] : 0;
                            currentLine[i] = (byte)(value + left >> 8);
                            currentLine[i + 1] = (byte)(value + left);
                        }
                        break;
                    }
                    if (this.bitsPerComponent == 8) {
                        for (int i = 0; i < this.lineLength; ++i) {
                            value = currentLine[i];
                            left = i - this.bytesPerChar >= 0 ? currentLine[i - this.bytesPerChar] : 0;
                            currentLine[i] = (byte)(value + left);
                        }
                        break;
                    }
                    throw new IOException(this.bitsPerComponent + " bits per component can't be processed.");
                }
                case 10: {
                    break;
                }
                case 11: {
                    int left;
                    int value;
                    for (int i = 0; i < this.lineLength; ++i) {
                        value = currentLine[i];
                        left = i - this.bytesPerChar >= 0 ? currentLine[i - this.bytesPerChar] : 0;
                        currentLine[i] = (byte)(value + left);
                    }
                    break;
                }
                case 12: {
                    int value;
                    for (int i = 0; i < this.lineLength; ++i) {
                        value = currentLine[i];
                        byte up = this.previousLine[i];
                        currentLine[i] = (byte)(value + up);
                    }
                    break;
                }
                case 13: {
                    byte up;
                    int left;
                    int value;
                    for (int i = 0; i < this.lineLength; ++i) {
                        value = currentLine[i];
                        left = i - this.bytesPerChar >= 0 ? currentLine[i - this.bytesPerChar] : 0;
                        up = this.previousLine[i];
                        currentLine[i] = (byte)(value + (left + up) / 2);
                    }
                    break;
                }
                case 14: {
                    byte up;
                    int left;
                    int value;
                    for (int i = 0; i < this.lineLength; ++i) {
                        value = currentLine[i];
                        left = i - this.bytesPerChar >= 0 ? currentLine[i - this.bytesPerChar] : 0;
                        up = this.previousLine[i];
                        byte upLeft = i - this.bytesPerChar >= 0 ? this.previousLine[i - this.bytesPerChar] : (byte)0;
                        int res = left + up - upLeft;
                        int leftDiff = Math.abs(res - left);
                        int upDiff = Math.abs(res - up);
                        int upLeftDiff = Math.abs(res - upLeft);
                        currentLine[i] = leftDiff <= upDiff && leftDiff <= upLeftDiff ? (byte)(value + left) : (upDiff <= upLeftDiff ? (byte)(value + up) : (byte)(value + upLeft));
                    }
                    break;
                }
            }
            System.arraycopy(currentLine, 0, buffer, outputPointer, this.lineLength);
            System.arraycopy(currentLine, 0, this.previousLine, 0, this.lineLength);
            if ((outputPointer += this.lineLength) + this.lineLength <= size) continue;
            return outputPointer;
        }
        return outputPointer;
    }

    private static byte predictorFromParams(COSDictionary decodeParams) {
        if (decodeParams.knownKey(ASAtom.PREDICTOR).booleanValue()) {
            return (byte)decodeParams.getIntegerKey(ASAtom.PREDICTOR).intValue();
        }
        return 1;
    }

    private static int colorsFromParams(COSDictionary decodeParams) {
        if (decodeParams.knownKey(ASAtom.COLORS).booleanValue()) {
            return decodeParams.getIntegerKey(ASAtom.COLORS).intValue();
        }
        return 1;
    }

    private static int bitsFromParams(COSDictionary decodeParams) {
        if (decodeParams.knownKey(ASAtom.BITS_PER_COMPONENT).booleanValue()) {
            return decodeParams.getIntegerKey(ASAtom.BITS_PER_COMPONENT).intValue();
        }
        return 8;
    }

    private static int columnsFromParams(COSDictionary decodeParams) {
        if (decodeParams.knownKey(ASAtom.COLUMNS).booleanValue()) {
            return decodeParams.getIntegerKey(ASAtom.COLUMNS).intValue();
        }
        return 1;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.streamEnded = false;
    }
}

