/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSFilters;
import org.verapdf.cos.COSHeader;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.objects.LowLvlInfoFeaturesObjectAdapter;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;

public class GFLowLvlInfoFeaturesObjectAdapter
implements LowLvlInfoFeaturesObjectAdapter {
    private static final Map<ASAtom, ASAtom> filtersAbbreviations;
    private boolean isPresent;
    private double headerVersion;
    private String catalogVersion;
    private int indirectObjectsNumber;
    private String creationId;
    private String modificationId;
    private boolean isTagged = false;
    private Set<String> filters;
    private List<String> errors;

    public GFLowLvlInfoFeaturesObjectAdapter(COSDocument document) {
        this.init(document);
    }

    private void init(COSDocument document) {
        boolean bl = this.isPresent = document != null;
        if (document != null) {
            PDCatalog catalog;
            PDDocument pdDocument;
            COSArray ids;
            COSHeader documentHeader = document.getHeader();
            if (documentHeader != null) {
                this.headerVersion = documentHeader.getVersion();
            }
            if (document.getObjects() != null) {
                this.indirectObjectsNumber = document.getObjects().size();
            }
            if ((ids = document.getID()) != null) {
                this.creationId = ids.at(0).getString();
                this.modificationId = ids.at(1).getString();
                if (ids.size() != 2 || this.creationId == null || this.modificationId == null) {
                    this.errors = new ArrayList<String>();
                    this.errors.add("Document's ID must be an array of two not null elements");
                }
            }
            if ((pdDocument = document.getPDDocument()) != null && (catalog = pdDocument.getCatalog()) != null) {
                this.catalogVersion = catalog.getNameKeyStringValue(ASAtom.VERSION);
                this.isTagged = catalog.getStructTreeRoot() != null;
            }
            this.filters = this.getAllFilters(document);
        }
    }

    private Set<String> getAllFilters(COSDocument document) {
        HashSet<String> res = new HashSet<String>();
        for (COSObject base : document.getObjects()) {
            if (base.getType() != COSObjType.COS_STREAM) continue;
            COSFilters baseFilters = ((COSStream)base.getDirectBase()).getFilters();
            GFLowLvlInfoFeaturesObjectAdapter.addFilters(res, baseFilters);
        }
        return res;
    }

    private static void addFilters(Set<String> res, COSFilters filters) {
        List<ASAtom> atoms = filters.getFilters();
        if (atoms != null) {
            for (ASAtom atom : atoms) {
                if (filtersAbbreviations.keySet().contains(atom)) {
                    atom = filtersAbbreviations.get(atom);
                }
                res.add(atom.getValue());
            }
        }
    }

    @Override
    public double getHeaderVersion() {
        return this.headerVersion;
    }

    @Override
    public String getCatalogVersion() {
        return this.catalogVersion;
    }

    @Override
    public int getIndirectObjectsNumber() {
        return this.indirectObjectsNumber;
    }

    @Override
    public String getCreationId() {
        return this.creationId;
    }

    @Override
    public String getModificationId() {
        return this.modificationId;
    }

    @Override
    public boolean isTagged() {
        return this.isTagged;
    }

    @Override
    public Set<String> getFilters() {
        return this.filters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.filters);
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.isPresent;
    }

    @Override
    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    static {
        HashMap<ASAtom, ASAtom> filtersAbbreviationsTemp = new HashMap<ASAtom, ASAtom>();
        filtersAbbreviationsTemp.put(ASAtom.ASCII_HEX_DECODE_ABBREVIATION, ASAtom.ASCII_HEX_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.ASCII85_DECODE_ABBREVIATION, ASAtom.ASCII85_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.LZW_DECODE_ABBREVIATION, ASAtom.LZW_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.FLATE_DECODE_ABBREVIATION, ASAtom.FLATE_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.RUN_LENGTH_DECODE_ABBREVIATION, ASAtom.RUN_LENGTH_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.CCITTFAX_DECODE_ABBREVIATION, ASAtom.CCITTFAX_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.DCT_DECODE_ABBREVIATION, ASAtom.DCT_DECODE);
        filtersAbbreviations = Collections.unmodifiableMap(filtersAbbreviationsTemp);
    }
}

