/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.PDOutlineDictionary;
import org.verapdf.pd.PDOutputIntent;
import org.verapdf.pd.PDPageTree;
import org.verapdf.pd.actions.PDAction;
import org.verapdf.pd.actions.PDCatalogAdditionalActions;
import org.verapdf.pd.form.PDAcroForm;
import org.verapdf.pd.optionalcontent.PDOptionalContentProperties;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.tools.PageLabels;

public class PDCatalog
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(PDCatalog.class.getCanonicalName());
    private PDPageTree pages = new PDPageTree();

    public PDCatalog() {
    }

    public PDCatalog(COSObject object) {
        super(object);
    }

    public PDPageTree getPageTree() {
        COSObject pages;
        if (this.pages.empty() && (pages = super.getObject().getKey(ASAtom.PAGES)) != null) {
            this.pages.setObject(pages);
        }
        return this.pages;
    }

    public PDMetadata getMetadata() {
        COSObject metadata = this.getKey(ASAtom.METADATA);
        if (metadata != null && metadata.getType() == COSObjType.COS_STREAM) {
            return new PDMetadata(metadata);
        }
        return null;
    }

    public PDStructTreeRoot getStructTreeRoot() {
        COSObject base = this.getKey(ASAtom.STRUCT_TREE_ROOT);
        if (base != null && base.getType() == COSObjType.COS_DICT) {
            return new PDStructTreeRoot(base);
        }
        return null;
    }

    public List<PDOutputIntent> getOutputIntents() {
        COSObject base = this.getKey(ASAtom.OUTPUT_INTENTS);
        if (base != null && base.getType() == COSObjType.COS_ARRAY) {
            if (base.isIndirect().booleanValue()) {
                base = base.getDirect();
            }
            ArrayList<PDOutputIntent> result = new ArrayList<PDOutputIntent>(base.size());
            for (COSObject obj : (COSArray)base.getDirectBase()) {
                if (obj == null || !obj.getType().isDictionaryBased()) continue;
                result.add(new PDOutputIntent(obj));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    public PDOptionalContentProperties getOCProperties() {
        COSObject object = this.getKey(ASAtom.OCPROPERTIES);
        if (object != null && !object.empty() && object.getType() == COSObjType.COS_DICT) {
            return new PDOptionalContentProperties(object);
        }
        return null;
    }

    public PDOutlineDictionary getOutlines() {
        COSObject outlines = this.getKey(ASAtom.OUTLINES);
        if (outlines != null && outlines.getType().isDictionaryBased()) {
            return new PDOutlineDictionary(outlines);
        }
        return null;
    }

    public PDAction getOpenAction() {
        COSObject openAction = this.getKey(ASAtom.OPEN_ACTION);
        if (openAction != null && openAction.getType() == COSObjType.COS_DICT) {
            return new PDAction(openAction);
        }
        return null;
    }

    public PDCatalogAdditionalActions getAdditionalActions() {
        COSObject aaDict = this.getKey(ASAtom.AA);
        if (aaDict != null && aaDict.getType() == COSObjType.COS_DICT) {
            return new PDCatalogAdditionalActions(aaDict);
        }
        return null;
    }

    public PDAcroForm getAcroForm() {
        COSObject acroForm = this.getKey(ASAtom.ACRO_FORM);
        if (acroForm != null && acroForm.getType().isDictionaryBased()) {
            return new PDAcroForm(acroForm);
        }
        return null;
    }

    public PDNamesDictionary getNamesDictionary() {
        COSObject buffer = this.getKey(ASAtom.NAMES);
        if (buffer != null && buffer.getType() == COSObjType.COS_DICT) {
            return new PDNamesDictionary(buffer);
        }
        return null;
    }

    public PageLabels getPageLabels() {
        COSObject labelsTree = this.getKey(ASAtom.PAGE_LABELS);
        if (labelsTree != null && !labelsTree.empty() && labelsTree.getType() == COSObjType.COS_DICT) {
            return new PageLabels((COSDictionary)labelsTree.getDirectBase());
        }
        return null;
    }

    public String getVersion() {
        COSObject version = this.getKey(ASAtom.VERSION);
        if (version == null || version.empty()) {
            return null;
        }
        if (version.getType() != COSObjType.COS_NAME) {
            LOGGER.log(Level.WARNING, "Entry Version in the catalog does not have type name");
            return null;
        }
        return version.getString();
    }
}

