/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser.postscript;

import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.parser.postscript.PSLiteralObject;
import org.verapdf.parser.postscript.PSOperator;
import org.verapdf.parser.postscript.PSProcedure;
import org.verapdf.parser.postscript.PostScriptException;

public abstract class PSObject
extends COSObject {
    private static final Logger LOGGER = Logger.getLogger(PSObject.class.getCanonicalName());

    protected PSObject(COSBase base) {
        super(base);
    }

    public abstract void execute(Stack<COSObject> var1, Map<ASAtom, COSObject> var2) throws PostScriptException;

    public static PSObject getPSObject(COSObject obj) {
        return PSObject.getPSObject(obj, false);
    }

    public static PSObject getPSObject(COSObject obj, boolean isExecutable) {
        if (obj instanceof PSObject) {
            return (PSObject)obj;
        }
        COSObjType type = obj.getType();
        if (type == COSObjType.COS_NAME && isExecutable) {
            return new PSOperator((COSName)obj.get());
        }
        if (type == COSObjType.COS_ARRAY && isExecutable) {
            return new PSProcedure((COSArray)obj.get());
        }
        if (type.isNumber() || type == COSObjType.COS_STRING || type == COSObjType.COS_BOOLEAN || type == COSObjType.COS_DICT || type == COSObjType.COS_NAME || type == COSObjType.COS_ARRAY) {
            return new PSLiteralObject(obj);
        }
        LOGGER.log(Level.FINE, "Can't get PSObject for COSType " + (Object)((Object)type));
        return new PSLiteralObject(obj);
    }
}

