/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import org.verapdf.core.utils.ValidationProgress;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.Location;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResults;
import org.verapdf.pdfa.validation.profiles.ErrorArgument;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.profiles.Variable;
import org.verapdf.pdfa.validation.validators.FlavourValidator;
import org.verapdf.pdfa.validation.validators.JavaScriptEvaluator;
import org.verapdf.processor.reports.enums.JobEndStatus;

public class BaseValidator
implements PDFAValidator {
    private static final Logger LOGGER = Logger.getLogger(BaseValidator.class.getCanonicalName());
    public static final int DEFAULT_MAX_NUMBER_OF_DISPLAYED_FAILED_CHECKS = 100;
    private static final int MAX_CHECKS_NUMBER = 10000;
    private static final URI componentId = URI.create("http://pdfa.verapdf.org/validators#default");
    private static final String componentName = "veraPDF Validator";
    private static final ComponentDetails componentDetails = Components.libraryDetails(componentId, "veraPDF Validator");
    List<FlavourValidator> validators = new LinkedList<FlavourValidator>();
    private ScriptableObject scope;
    private final Deque<org.verapdf.model.baselayer.Object> objectsStack = new ArrayDeque<org.verapdf.model.baselayer.Object>();
    private final Deque<String> objectsContext = new ArrayDeque<String>();
    protected volatile boolean abortProcessing = false;
    protected final boolean logPassedChecks;
    protected final int maxNumberOfDisplayedFailedChecks;
    private boolean showErrorMessages = false;
    protected final ValidationProgress validationProgress;
    protected volatile JobEndStatus jobEndStatus = JobEndStatus.NORMAL;
    private final Set<String> idSet = new HashSet<String>();
    protected String rootType;

    protected BaseValidator(ValidationProfile profile) {
        this(profile, false);
    }

    protected BaseValidator(List<ValidationProfile> profiles) {
        this(profiles, 100, false, false, false);
    }

    protected BaseValidator(ValidationProfile profile, boolean logPassedChecks) {
        this(profile, 100, logPassedChecks, false, false);
    }

    protected BaseValidator(ValidationProfile profile, int maxNumberOfDisplayedFailedChecks, boolean logPassedChecks, boolean showErrorMessages, boolean showProgress) {
        this(Collections.singletonList(profile), maxNumberOfDisplayedFailedChecks, logPassedChecks, showErrorMessages, showProgress);
    }

    protected BaseValidator(List<ValidationProfile> profiles, int maxNumberOfDisplayedFailedChecks, boolean logPassedChecks, boolean showErrorMessages, boolean showProgress) {
        this.createCompatibleValidators(profiles);
        this.maxNumberOfDisplayedFailedChecks = maxNumberOfDisplayedFailedChecks;
        this.logPassedChecks = logPassedChecks;
        this.showErrorMessages = showErrorMessages;
        this.validationProgress = new ValidationProgress(showProgress);
    }

    private void createCompatibleValidators(List<ValidationProfile> profiles) {
        PDFAFlavour flavour = profiles.get(0).getPDFAFlavour();
        PDFAFlavour.PDFSpecification pdfSpecification = flavour.getPart().getPdfSpecification();
        for (ValidationProfile profile : profiles) {
            PDFAFlavour currentFlavour = profile.getPDFAFlavour();
            PDFAFlavour.PDFSpecification currentPDFSpecification = currentFlavour.getPart().getPdfSpecification();
            if (pdfSpecification == currentPDFSpecification) {
                this.validators.add(new FlavourValidator(profile));
                continue;
            }
            LOGGER.log(Level.WARNING, String.format("PDF version %s of detected flavour %s is incompatible with the PDF version %s of other detected flavour %s. The validation of flavour %s is skipped", new Object[]{currentPDFSpecification, currentFlavour, pdfSpecification, flavour, currentFlavour}));
        }
    }

    @Override
    public ValidationProfile getProfile() {
        return this.validators.get(0).getProfile();
    }

    private List<PDFAFlavour> getFlavours() {
        LinkedList<PDFAFlavour> flavours = new LinkedList<PDFAFlavour>();
        for (FlavourValidator validator : this.validators) {
            flavours.add(validator.getProfile().getPDFAFlavour());
        }
        return flavours;
    }

    @Override
    public ValidationResult validate(PDFAParser toValidate) throws ValidationException {
        this.validators = Collections.singletonList(this.validators.get(0));
        List<ValidationResult> validationResults = this.validateAll(toValidate);
        return validationResults.get(0);
    }

    @Override
    public List<ValidationResult> validateAll(PDFAParser toValidate) throws ValidationException {
        toValidate.setFlavours(this.getFlavours());
        try {
            return this.validate(toValidate.getRoot());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Caught unexpected runtime exception during validation", e);
        }
        catch (ModelParsingException excep) {
            throw new ValidationException("Parsing problem trying to validate.", excep);
        }
    }

    @Override
    public ComponentDetails getDetails() {
        return componentDetails;
    }

    @Override
    public String getValidationProgressString() {
        return this.validationProgress.getCurrentValidationJobProgressWithCommas();
    }

    @Override
    public void cancelValidation(JobEndStatus endStatus) {
        this.jobEndStatus = endStatus;
        this.abortProcessing = true;
    }

    protected List<ValidationResult> validate(org.verapdf.model.baselayer.Object root) throws ValidationException {
        this.initialise();
        this.validationProgress.updateVariables();
        this.rootType = root.getObjectType();
        this.objectsStack.push(root);
        this.objectsContext.push("root");
        if (root.getID() != null) {
            this.idSet.add(root.getID());
        }
        while (!this.objectsStack.isEmpty() && !this.abortProcessing) {
            this.checkNext();
            this.validationProgress.incrementNumberOfProcessedObjects();
            this.validationProgress.updateNumberOfObjectsToBeProcessed(this.objectsStack.size());
        }
        for (FlavourValidator validator : this.validators) {
            for (Map.Entry<Rule, List<ObjectWithContext>> entry : validator.getDeferredRules().entrySet()) {
                for (ObjectWithContext objectWithContext : entry.getValue()) {
                    this.checkObjWithRule(validator, objectWithContext.getObject(), objectWithContext.getContext(), entry.getKey());
                }
            }
        }
        this.validationProgress.showProgressAfterValidation();
        JavaScriptEvaluator.exitContext();
        LinkedList<ValidationResult> results = new LinkedList<ValidationResult>();
        for (FlavourValidator validator : this.validators) {
            results.add(ValidationResults.resultFromValues(validator.getProfile(), validator.results, validator.getFailedChecks(), validator.isCompliant, validator.testCounter, this.jobEndStatus));
        }
        return results;
    }

    protected void initialise() {
        this.scope = JavaScriptEvaluator.initialise();
        this.objectsStack.clear();
        this.objectsContext.clear();
        this.idSet.clear();
        for (FlavourValidator validator : this.validators) {
            validator.getFailedChecks().clear();
            validator.getDeferredRules().clear();
            validator.results.clear();
            validator.testCounter = 0;
            validator.isCompliant = true;
        }
        this.initializeAllVariables();
    }

    private void initializeAllVariables() {
        for (FlavourValidator flavourValidator : this.validators) {
            for (Variable var : flavourValidator.getProfile().getVariables()) {
                if (var == null) continue;
                Object res = JavaScriptEvaluator.evaluateString(var.getDefaultValue(), this.scope);
                if (res instanceof NativeJavaObject) {
                    res = ((NativeJavaObject)res).unwrap();
                }
                this.scope.put(var.getName(), (Scriptable)this.scope, res);
            }
        }
    }

    private void checkNext() throws ValidationException {
        org.verapdf.model.baselayer.Object checkObject = this.objectsStack.pop();
        String checkContext = this.objectsContext.pop();
        this.checkAllRules(checkObject, checkContext);
        this.updateVariables(checkObject);
        this.addAllLinkedObjects(checkObject, checkContext);
    }

    private void updateVariables(org.verapdf.model.baselayer.Object object) {
        if (object != null) {
            this.updateVariableForObjectWithType(object, object.getObjectType());
            for (String parentName : object.getSuperTypes()) {
                this.updateVariableForObjectWithType(object, parentName);
            }
        }
    }

    private void updateVariableForObjectWithType(org.verapdf.model.baselayer.Object object, String objectType) {
        for (FlavourValidator flavourValidator : this.validators) {
            for (Variable var : flavourValidator.getProfile().getVariablesByObject(objectType)) {
                if (var == null) continue;
                Object variable = JavaScriptEvaluator.evalVariableResult(var, object, this.scope);
                this.scope.put(var.getName(), (Scriptable)this.scope, variable);
            }
        }
    }

    private void addAllLinkedObjects(org.verapdf.model.baselayer.Object checkObject, String checkContext) throws ValidationException {
        List<String> links = checkObject.getLinks();
        for (int j = links.size() - 1; j >= 0; --j) {
            String link = links.get(j);
            if (link == null) {
                throw new ValidationException("There is a null link name in an object. Context: " + checkContext);
            }
            List<? extends org.verapdf.model.baselayer.Object> objects = checkObject.getLinkedObjects(link);
            if (objects == null) {
                throw new ValidationException("There is a null link in an object. Context: " + checkContext);
            }
            for (int i = objects.size() - 1; i >= 0; --i) {
                org.verapdf.model.baselayer.Object obj = objects.get(i);
                StringBuilder path = new StringBuilder(checkContext);
                path.append("/");
                path.append(link);
                path.append("[");
                path.append(i);
                path.append("]");
                if (obj == null) {
                    throw new ValidationException("There is a null link in an object. Context of the link: " + path);
                }
                if (!this.checkRequired(obj)) continue;
                this.objectsStack.push(obj);
                if (obj.getID() != null) {
                    path.append("(");
                    path.append(obj.getID());
                    path.append(")");
                    this.idSet.add(obj.getID());
                }
                if (obj.getExtraContext() != null) {
                    path.append("{");
                    path.append(obj.getExtraContext());
                    path.append("}");
                }
                this.objectsContext.push(path.toString());
            }
        }
    }

    private boolean checkRequired(org.verapdf.model.baselayer.Object obj) {
        return obj.getID() == null || !this.idSet.contains(obj.getID());
    }

    private boolean checkAllRules(org.verapdf.model.baselayer.Object checkObject, String checkContext) {
        boolean res = true;
        for (FlavourValidator flavourValidator : this.validators) {
            Set<Rule> roolsForObject = flavourValidator.getProfile().getRulesByObject(checkObject.getObjectType());
            for (Rule rule : roolsForObject) {
                res &= this.firstProcessObjectWithRule(flavourValidator, checkObject, checkContext, rule);
            }
            for (String checkType : checkObject.getSuperTypes()) {
                roolsForObject = flavourValidator.getProfile().getRulesByObject(checkType);
                if (roolsForObject == null) continue;
                for (Rule rule : roolsForObject) {
                    if (rule == null) continue;
                    res &= this.firstProcessObjectWithRule(flavourValidator, checkObject, checkContext, rule);
                }
            }
        }
        return res;
    }

    public boolean firstProcessObjectWithRule(FlavourValidator flavourValidator, org.verapdf.model.baselayer.Object checkObject, String checkContext, Rule rule) {
        Boolean deferred = rule.getDeferred();
        if (deferred != null && deferred.booleanValue()) {
            List list = flavourValidator.getDeferredRules().computeIfAbsent(rule, k -> new ArrayList());
            list.add(new ObjectWithContext(checkObject, checkContext));
            return true;
        }
        return this.checkObjWithRule(flavourValidator, checkObject, checkContext, rule);
    }

    private boolean checkObjWithRule(FlavourValidator flavourValidator, org.verapdf.model.baselayer.Object obj, String contextForRule, Rule rule) {
        boolean testEvalResult = JavaScriptEvaluator.getTestEvalResult(obj, rule, this.scope);
        this.processAssertionResult(flavourValidator, testEvalResult, contextForRule, rule, obj);
        this.validationProgress.updateNumberOfFailedChecks(flavourValidator.getFailedChecks().size());
        this.validationProgress.incrementNumberOfChecks();
        return testEvalResult;
    }

    protected void processAssertionResult(FlavourValidator flavourValidator, boolean assertionResult, String locationContext, Rule rule, org.verapdf.model.baselayer.Object obj) {
        if (!this.abortProcessing) {
            ++flavourValidator.testCounter;
            if (flavourValidator.isCompliant) {
                flavourValidator.isCompliant = assertionResult;
            }
            if (!assertionResult) {
                int failedChecksNumberOfRule = flavourValidator.getFailedChecks().getOrDefault(rule.getRuleId(), 0);
                flavourValidator.getFailedChecks().put(rule.getRuleId(), ++failedChecksNumberOfRule);
                if (!(failedChecksNumberOfRule > this.maxNumberOfDisplayedFailedChecks && this.maxNumberOfDisplayedFailedChecks != -1 || flavourValidator.results.size() > 10000 && failedChecksNumberOfRule > 1)) {
                    Location location = ValidationResults.locationFromValues(this.rootType, locationContext);
                    List<ErrorArgument> errorArguments = this.showErrorMessages ? JavaScriptEvaluator.getErrorArgumentsResult(obj, rule.getError().getArguments(), this.scope) : Collections.emptyList();
                    String errorMessage = this.showErrorMessages ? this.createErrorMessage(rule.getError().getMessage(), errorArguments) : null;
                    TestAssertion assertion = ValidationResults.assertionFromValues(flavourValidator.testCounter, rule.getRuleId(), TestAssertion.Status.FAILED, rule.getDescription(), location, obj.getContext(), errorMessage, errorArguments);
                    flavourValidator.results.add(assertion);
                }
            } else if (this.logPassedChecks && flavourValidator.results.size() <= 10000) {
                Location location = ValidationResults.locationFromValues(this.rootType, locationContext);
                TestAssertion assertion = ValidationResults.assertionFromValues(flavourValidator.testCounter, rule.getRuleId(), TestAssertion.Status.PASSED, rule.getDescription(), location, obj.getContext(), null, Collections.emptyList());
                flavourValidator.results.add(assertion);
            }
        }
    }

    private String createErrorMessage(String errorMessage, List<ErrorArgument> arguments) {
        String result = errorMessage;
        for (int i = arguments.size(); i > 0; --i) {
            ErrorArgument argument = arguments.get(i - 1);
            String value = argument.getArgumentValue() != null ? argument.getArgumentValue() : "null";
            result = result.replace("%" + argument.getName() + "%", value);
            result = result.replace("%" + i, value);
        }
        return result;
    }

    @Override
    public void close() {
    }

    public static class ObjectWithContext {
        private final org.verapdf.model.baselayer.Object object;
        private final String context;

        public ObjectWithContext(org.verapdf.model.baselayer.Object object, String context) {
            this.object = object;
            this.context = context;
        }

        public org.verapdf.model.baselayer.Object getObject() {
            return this.object;
        }

        public String getContext() {
            return this.context;
        }
    }
}

