/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;

public class RunLengthDecode
extends ASBufferedInFilter {
    private boolean streamEnded = false;
    private byte[] leftoverBuffer = new byte[0];
    private int leftoverSize = 0;

    public RunLengthDecode(ASInputStream stream) throws IOException {
        super(stream);
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        if (this.streamEnded) {
            return -1;
        }
        int outputPointer = 0;
        if (this.leftoverSize > 0) {
            if (this.leftoverSize >= size) {
                System.arraycopy(this.leftoverBuffer, this.leftoverBuffer.length - this.leftoverSize, buffer, 0, size);
                this.leftoverSize -= size;
                return size;
            }
            System.arraycopy(this.leftoverBuffer, this.leftoverBuffer.length - this.leftoverSize, buffer, 0, this.leftoverSize);
            outputPointer = this.leftoverSize;
            this.leftoverSize = 0;
        }
        if (this.bufferSize() == 0 && this.feedBuffer(this.getBufferCapacity()) == -1) {
            this.streamEnded = true;
        }
        while (!this.streamEnded) {
            int i;
            if (this.bufferSize() == 0 && this.feedBuffer(this.getBufferCapacity()) == -1) {
                this.streamEnded = true;
                break;
            }
            byte b = this.bufferPop();
            if (b >= 0) {
                int readAgain;
                if (this.bufferSize() == 0 && this.feedBuffer(this.getBufferCapacity()) == -1) {
                    this.streamEnded = true;
                    break;
                }
                int count = b + 1;
                byte[] data = new byte[count];
                for (int read = this.bufferPopArray(data, count); read != count; read += readAgain) {
                    if (this.feedBuffer(this.getBufferCapacity()) == -1) {
                        this.streamEnded = true;
                        break;
                    }
                    byte[] extraBytes = new byte[count - read];
                    readAgain = this.bufferPopArray(extraBytes, extraBytes.length);
                    System.arraycopy(extraBytes, 0, data, read, readAgain);
                }
                if (this.streamEnded) break;
                int leftBufferSize = size - outputPointer;
                if (count > leftBufferSize) {
                    System.arraycopy(data, 0, buffer, outputPointer, leftBufferSize);
                    this.leftoverSize = count - leftBufferSize;
                    this.leftoverBuffer = new byte[this.leftoverSize];
                    System.arraycopy(data, leftBufferSize, this.leftoverBuffer, 0, this.leftoverSize);
                    return size;
                }
                System.arraycopy(data, 0, buffer, outputPointer, count);
                outputPointer += count;
                continue;
            }
            int runLength = -b + 1;
            if (this.bufferSize() == 0 && this.feedBuffer(this.getBufferCapacity()) == -1) {
                this.streamEnded = true;
                break;
            }
            byte value = this.bufferPop();
            int leftBufferSize = size - outputPointer;
            int count = Math.min(leftBufferSize, runLength);
            for (i = 0; i < count; ++i) {
                buffer[outputPointer++] = value;
            }
            if (runLength <= leftBufferSize) continue;
            this.leftoverSize = runLength - leftBufferSize;
            this.leftoverBuffer = new byte[this.leftoverSize];
            for (i = 0; i < this.leftoverSize; ++i) {
                this.leftoverBuffer[i] = value;
            }
            return size;
        }
        return outputPointer;
    }
}

