/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.utils.RsrcUtils;

public class ResolvedResourceImpl
extends ResolvedResource {
    private final URI resolvedURI;
    private final URI localURI;
    private final InputStream inputStream;
    private final String contentType;
    private final Map<String, List<String>> headers;
    private final int statusCode;

    public ResolvedResourceImpl(URI resolvedURI, URI localURI, InputStream stream, String contentType) {
        this.resolvedURI = resolvedURI;
        this.localURI = localURI;
        this.inputStream = stream;
        this.contentType = contentType;
        this.headers = Collections.emptyMap();
        this.statusCode = 200;
    }

    public ResolvedResourceImpl(URI resolvedURI, URI localURI, InputStream stream, int status, Map<String, List<String>> headers) {
        this.resolvedURI = resolvedURI;
        this.localURI = localURI;
        this.inputStream = stream;
        this.headers = headers;
        String ctype = null;
        for (String name : headers.keySet()) {
            if (!"content-type".equalsIgnoreCase(name)) continue;
            ctype = headers.get(name).get(0);
        }
        this.contentType = ctype;
        this.statusCode = status;
    }

    @Override
    public URI getResolvedURI() {
        return this.resolvedURI;
    }

    @Override
    public URI getLocalURI() {
        return this.localURI;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return RsrcUtils.getHeader(headerName, this.headers);
    }
}

