/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.visitor.IndirectWriter;
import org.verapdf.cos.visitor.Writer;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.PDOutlineDictionary;
import org.verapdf.pd.PDOutputIntent;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.PDPageTree;
import org.verapdf.pd.form.PDAcroForm;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.tools.StaticResources;

public class PDDocument {
    private static final Logger LOGGER = Logger.getLogger(PDDocument.class.getCanonicalName());
    public static final String PDF_HEADER_DEFAULT = "%PDF-1.4";
    private final PDCatalog catalog;
    private COSDocument document;

    public PDDocument() throws IOException {
        try {
            this.catalog = new PDCatalog();
            this.constructDocument();
            this.checkPages();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    public PDDocument(String filename) throws IOException {
        try {
            this.catalog = new PDCatalog();
            this.document = new COSDocument(filename, this);
            this.checkPages();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    public PDDocument(InputStream fileStream) throws IOException {
        try {
            this.catalog = new PDCatalog();
            this.document = new COSDocument(fileStream, this);
            this.checkPages();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private void constructDocument() {
        this.document = new COSDocument(this);
        this.document.setHeader(PDF_HEADER_DEFAULT);
        this.getCatalog();
    }

    public void open(String filename) throws IOException {
        this.close();
        this.document = new COSDocument(filename, this);
    }

    public void open(InputStream inputStream) throws IOException {
        this.close();
        this.document = new COSDocument(inputStream, this);
    }

    public void close() {
        if (this.document != null) {
            try {
                if (this.document.getPDFSource() != null) {
                    this.document.getPDFSource().close();
                }
                this.document.getResourceHandler().close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error in closing stream", e);
            }
            this.document = null;
        }
        StaticResources.clear();
        this.catalog.clear();
    }

    public PDCatalog getCatalog() {
        if (!this.catalog.empty() || this.document == null) {
            return this.catalog;
        }
        COSObject root = this.document.getTrailer().getRoot();
        if (root == COSObject.getEmpty()) {
            root = new COSObject();
            this.document.getTrailer().setRoot(root);
        }
        if (!root.empty()) {
            this.catalog.setObject(root);
            return this.catalog;
        }
        root.setNameKey(ASAtom.TYPE, ASAtom.CATALOG);
        COSObject pages = new COSObject();
        pages.setNameKey(ASAtom.TYPE, ASAtom.PAGES);
        pages.setArrayKey(ASAtom.KIDS);
        pages.setIntegerKey(ASAtom.COUNT, 0L);
        pages = COSIndirect.construct(root, this.document);
        root.setKey(ASAtom.PAGES, pages);
        root = COSIndirect.construct(root, this.document);
        this.document.getTrailer().setRoot(root);
        this.catalog.setObject(root);
        return this.catalog;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public int getNumberOfPages() {
        return this.getCatalog().getPageTree().getPageCount();
    }

    public List<PDPage> getPages() {
        ArrayList<PDPage> pages = new ArrayList<PDPage>();
        int pageCount = this.getCatalog().getPageTree().getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            pages.add(this.getPage(i));
        }
        return pages;
    }

    public PDPage getPage(int number) {
        return this.getCatalog().getPageTree().getPage(number);
    }

    public void addPage(PDPage page, int number) {
        if (this.document == null) {
            return;
        }
        PDPageTree pages = this.getCatalog().getPageTree();
        page.getObject().setKey(ASAtom.PARENT, pages.getObject());
        if (pages.addPage(page, number)) {
            this.getCatalog().setKey(ASAtom.PAGES, pages.getRoot().getObject());
        }
        COSObject obj = pages.getObject();
        this.document.setObject(obj);
    }

    public PDPage newPage(double[] bbox, int insertAt) {
        PDPage page = new PDPage(bbox, this.document);
        this.addPage(page, insertAt);
        return page;
    }

    public void save() {
    }

    public void saveAs(String fileName) throws IOException {
        IndirectWriter out = new IndirectWriter(this.document, fileName, false, 0L);
        this.saveAs(out, fileName);
    }

    public void saveAs(Writer out, String filename) {
        if (this.document == null) {
            return;
        }
        this.document.saveAs(out);
        out.close();
    }

    public void saveTo(OutputStream stream) {
        if (this.document != null) {
            this.document.saveTo(stream);
        }
    }

    public PDStructTreeRoot getStructTreeRoot() {
        return this.getCatalog().getStructTreeRoot();
    }

    public PDMetadata getMetadata() {
        return this.getCatalog().getMetadata();
    }

    public List<PDOutputIntent> getOutputIntents() {
        return this.getCatalog().getOutputIntents();
    }

    public PDOutlineDictionary getOutlines() {
        return this.getCatalog().getOutlines();
    }

    public PDAcroForm getAcroForm() {
        return this.getCatalog().getAcroForm();
    }

    public SeekableInputStream getPDFSource() {
        return this.document.getPDFSource();
    }

    private void checkPages() throws IOException {
        if (this.getNumberOfPages() == 0) {
            throw new IOException("Pages not found");
        }
    }

    public Float getVersion() {
        COSDocument cosDocument = this.getDocument();
        Float version = cosDocument != null ? Float.valueOf(cosDocument.getHeader().getVersion()) : null;
        Float catalogVersion = this.getCatalog().getFloatVersion();
        if (catalogVersion != null && (version == null || version.floatValue() < catalogVersion.floatValue())) {
            version = catalogVersion;
        }
        return version;
    }
}

