/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.pdlayer.PDStructTreeRoot;
import org.verapdf.pd.structure.PDStructElem;

public class GFPDStructTreeRoot
extends GFPDObject
implements PDStructTreeRoot {
    public static final String STRUCT_TREE_ROOT_TYPE = "PDStructTreeRoot";
    public static final String CHILDREN = "K";
    public static final String ROLE_MAP_NAMES = "roleMapNames";
    private List<org.verapdf.model.pdlayer.PDStructElem> children = null;

    public GFPDStructTreeRoot(org.verapdf.pd.structure.PDStructTreeRoot treeRoot) {
        super(treeRoot, STRUCT_TREE_ROOT_TYPE);
        StaticContainers.setRoleMapHelper(treeRoot.getRoleMap());
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "roleMapNames": {
                return this.getRoleMapNames();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDStructElem> getChildren() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        return this.children;
    }

    private List<org.verapdf.model.pdlayer.PDStructElem> parseChildren() {
        List<PDStructElem> elements = ((org.verapdf.pd.structure.PDStructTreeRoot)this.simplePDObject).getChildren();
        if (!elements.isEmpty()) {
            ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
            for (PDStructElem element : elements) {
                res.add(new GFPDStructElem(element));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getRoleMapNames() {
        Map<ASAtom, ASAtom> roleMap;
        if (this.simplePDObject != null && (roleMap = ((org.verapdf.pd.structure.PDStructTreeRoot)this.simplePDObject).getRoleMap()) != null) {
            ArrayList<CosUnicodeName> res = new ArrayList<CosUnicodeName>();
            for (Map.Entry<ASAtom, ASAtom> entry : roleMap.entrySet()) {
                res.add(new GFCosUnicodeName((COSName)COSName.construct(entry.getKey()).get()));
                res.add(new GFCosUnicodeName((COSName)COSName.construct(entry.getValue()).get()));
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    public String gettopLevelFirstElementStandartType() {
        if (this.children == null) {
            this.children = this.parseChildren();
        }
        if (!this.children.isEmpty()) {
            return this.children.get(0).getstandardType();
        }
        return null;
    }
}

