/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.PDPageTreeBranch;

public class PDPageTree {
    private PDPageTreeBranch root;

    public PDPageTree() {
        this.root = new PDPageTreeBranch();
    }

    public PDPageTree(COSObject object) throws Exception {
        this.root = new PDPageTreeBranch(object);
    }

    public PDPageTreeBranch getRoot() {
        return this.root;
    }

    public COSObject getObject() {
        return this.getRoot().getObject();
    }

    public void setObject(COSObject object) {
        this.getRoot().setObject(object);
    }

    public boolean empty() {
        return this.getRoot().empty();
    }

    public int getPageCount() {
        return this.getRoot().getLeafCount();
    }

    public PDPage getPage(int index) {
        if (index < this.getPageCount()) {
            int totalIndex = index;
            PDPage page = this.getRoot().findTerminalPDPage(index);
            if (page != null) {
                page.pageNumber = index;
                page.pagesTotal = totalIndex;
            }
            return page;
        }
        return null;
    }

    public PDPage newPage(int insertAt) {
        PDPage page = new PDPage(null);
        if (this.addPage(page, insertAt)) {
            page.pageNumber = insertAt == -1 ? this.getPageCount() - 1 : insertAt;
        }
        return page;
    }

    public boolean addPage(PDPage page, int insertAt) {
        PDPageTreeBranch branch = this.getRoot().findTerminal(insertAt);
        if (branch.insertLeaf(page, insertAt)) {
            this.root = this.getRoot().getParent();
            return true;
        }
        return false;
    }
}

