/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.type1.BaseCharStringParser;

class Type2CharStringParser
extends BaseCharStringParser {
    private static final int TWO_POWER_16 = 65536;

    Type2CharStringParser(ASInputStream stream) throws IOException {
        super(stream);
    }

    Type2CharStringParser(ASInputStream stream, CFFIndex localSubrs, int bias, CFFIndex globalSubrs, int gBias) throws IOException {
        super(stream, localSubrs, bias, globalSubrs, gBias);
    }

    @Override
    protected boolean processNextOperator(int nextByte) throws IOException {
        switch (nextByte) {
            case 19: 
            case 20: {
                if (this.stack.empty()) break;
                this.setWidth((CFFNumber)this.stack.get(0));
                this.stack.clear();
                return true;
            }
            case 14: {
                if (this.stack.empty() || this.stack.size() == 4) break;
                this.setWidth((CFFNumber)this.stack.get(0));
                this.stack.clear();
                return true;
            }
            case 4: 
            case 22: {
                if (this.stack.size() > 1) {
                    this.setWidth((CFFNumber)this.stack.get(0));
                    this.stack.clear();
                    return true;
                }
                this.stack.pop();
                break;
            }
            case 21: {
                if (this.stack.size() > 2) {
                    this.setWidth((CFFNumber)this.stack.get(0));
                    this.stack.clear();
                    return true;
                }
                this.popStack(2);
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 23: {
                if (this.stack.size() % 2 == 1) {
                    this.setWidth((CFFNumber)this.stack.get(0));
                    return true;
                }
                this.stack.clear();
                break;
            }
            case 28: {
                this.stack.push(this.readNextNumber(nextByte));
                return false;
            }
            case 10: {
                int subrNum = (int)((CFFNumber)this.stack.pop()).getInteger();
                if (this.stack.empty() && this.localSubrs.size() > subrNum + this.bias) {
                    CFFNumber subrWidth = this.getWidthFromSubroutine(this.localSubrs.get(subrNum + this.bias));
                    if (subrWidth != null) {
                        this.setWidth(subrWidth);
                    } else if (!this.stack.empty()) {
                        return false;
                    }
                } else if (!this.stack.empty()) {
                    this.setWidth((CFFNumber)this.stack.get(0));
                }
                return true;
            }
            case 29: {
                int subrNum = (int)((CFFNumber)this.stack.pop()).getInteger();
                if (this.stack.empty() && this.globalSubrs.size() > subrNum + this.gBias) {
                    CFFNumber subrWidth = this.getWidthFromSubroutine(this.globalSubrs.get(subrNum + this.gBias));
                    if (subrWidth != null) {
                        this.setWidth(subrWidth);
                    } else if (!this.stack.empty()) {
                        return false;
                    }
                } else if (!this.stack.empty()) {
                    this.setWidth((CFFNumber)this.stack.get(0));
                    this.stack.clear();
                }
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                this.stack.clear();
                break;
            }
            case 11: {
                break;
            }
            default: {
                this.stack.clear();
            }
        }
        return true;
    }

    private CFFNumber getWidthFromSubroutine(byte[] subr) throws IOException {
        ASMemoryInStream subrStream = new ASMemoryInStream(subr, subr.length, false);
        Type2CharStringParser parser = new Type2CharStringParser(subrStream, this.localSubrs, this.bias, this.globalSubrs, this.gBias);
        if (parser.getWidth() != null) {
            return parser.getWidth();
        }
        for (int i = 0; i < parser.stack.size(); ++i) {
            this.stack.push(parser.stack.get(i));
        }
        return null;
    }

    @Override
    protected CFFNumber readNextNumber(int firstByte) throws IOException {
        byte[] buf = new byte[4];
        if (firstByte == 28) {
            this.stream.read(buf, 2);
            return new CFFNumber((char)((buf[0] & 0xFF) << 8 | buf[1] & 0xFF));
        }
        this.stream.read(buf, 4);
        int integer = 0;
        for (int i = 0; i < 3; ++i) {
            integer |= buf[i] & 0xFF;
            integer <<= 8;
        }
        float res = integer |= buf[3] & 0xFF;
        return new CFFNumber(res / 65536.0f);
    }
}

