/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.verapdf.as.filters.io.ASBufferedInFilter;

public class EncryptionToolsRevision6 {
    public static byte[] getFileEncryptionKey(byte[] password, byte[] o, byte[] u, byte[] oe, byte[] ue) throws GeneralSecurityException {
        Cipher aes;
        SecretKeySpec key;
        byte[] aesKey;
        byte[] hash = EncryptionToolsRevision6.computeHashRevision6(password, o, u, true);
        boolean isUser = false;
        if (!Arrays.equals(hash, EncryptionToolsRevision6.getHashValueFromString(o))) {
            isUser = true;
            hash = EncryptionToolsRevision6.computeHashRevision6(password, u, u, false);
            if (!Arrays.equals(hash, EncryptionToolsRevision6.getHashValueFromString(u))) {
                throw new GeneralSecurityException("Incorrect password: failed check of owner hash.");
            }
        }
        byte[] res = null;
        if (oe != null && !isUser) {
            aesKey = EncryptionToolsRevision6.computeHashRevision6(password, o, u, true);
            EncryptionToolsRevision6.enableAES256();
            key = new SecretKeySpec(aesKey, "AES");
            aes = Cipher.getInstance("AES/CBC/NoPadding");
            aes.init(1, key);
            res = aes.doFinal(oe);
        }
        if (ue != null && isUser) {
            aesKey = EncryptionToolsRevision6.computeHashRevision6(password, u, u, false);
            EncryptionToolsRevision6.enableAES256();
            key = new SecretKeySpec(aesKey, "AES");
            aes = Cipher.getInstance("AES/CBC/NoPadding");
            aes.init(1, key);
            res = aes.doFinal(ue);
        }
        return res;
    }

    public static byte[] computeHashRevision6(byte[] password, byte[] string, byte[] u, boolean isCheckingOwnerPassword) throws GeneralSecurityException {
        byte[] hashInput = ASBufferedInFilter.concatenate(password, password.length, EncryptionToolsRevision6.getValSaltFromString(string), 8);
        if (isCheckingOwnerPassword) {
            hashInput = ASBufferedInFilter.concatenate(hashInput, hashInput.length, u, u.length);
        }
        int rounds = 0;
        byte[] k = EncryptionToolsRevision6.getSHAHash(256, hashInput);
        while (true) {
            byte[] sequence = ASBufferedInFilter.concatenate(password, password.length, k, k.length);
            if (isCheckingOwnerPassword) {
                sequence = ASBufferedInFilter.concatenate(sequence, sequence.length, u, u.length);
            }
            byte[] k1 = EncryptionToolsRevision6.repeatString(sequence, 64);
            IvParameterSpec initializingVector = new IvParameterSpec(Arrays.copyOfRange(k, 16, 32));
            SecretKeySpec key = new SecretKeySpec(Arrays.copyOf(k, 16), "AES");
            Cipher aes = Cipher.getInstance("AES/CBC/NoPadding");
            aes.init(1, (Key)key, initializingVector);
            byte[] e = aes.doFinal(k1);
            int shaType = EncryptionToolsRevision6.getReminderByModulo3(Arrays.copyOf(e, 16));
            byte[] byArray = shaType == 0 ? EncryptionToolsRevision6.getSHAHash(256, e) : (k = shaType == 1 ? EncryptionToolsRevision6.getSHAHash(384, e) : EncryptionToolsRevision6.getSHAHash(512, e));
            if (rounds >= 63 && (e[e.length - 1] & 0xFF) <= rounds - 32) break;
            ++rounds;
        }
        return Arrays.copyOf(k, 32);
    }

    public static void enableAES256() throws GeneralSecurityException {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            field.set(null, Boolean.FALSE);
        }
        catch (Exception ex) {
            throw new GeneralSecurityException("Can't enable using of 256-bit key for AES encryption", ex);
        }
    }

    private static byte[] repeatString(byte[] string, int amount) {
        byte[] res = new byte[string.length * amount];
        for (int i = 0; i < amount; ++i) {
            System.arraycopy(string, 0, res, i * string.length, string.length);
        }
        return res;
    }

    private static byte[] getSHAHash(int shaNum, byte[] message) throws NoSuchAlgorithmException {
        if (shaNum != 256 && shaNum != 384 && shaNum != 512) {
            throw new IllegalStateException("Can't use SHA-" + shaNum + " hash.");
        }
        String shaMD = "SHA-" + shaNum;
        MessageDigest md = MessageDigest.getInstance(shaMD);
        md.update(message);
        return md.digest();
    }

    private static byte[] getHashValueFromString(byte[] string) {
        return Arrays.copyOf(string, 32);
    }

    private static byte[] getValSaltFromString(byte[] string) {
        return Arrays.copyOfRange(string, 32, 40);
    }

    private static byte[] getKeySaltFromString(byte[] string) {
        return Arrays.copyOfRange(string, 40, 48);
    }

    private static int getReminderByModulo3(byte[] array) {
        int res = 0;
        for (int i = 0; i < array.length; ++i) {
            res += array[i] & 0xFF;
        }
        return res % 3;
    }
}

