/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.xml.bind.JAXBException;
import org.verapdf.extensions.ExtensionObjectType;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.processor.app.ConfigManager;

public class ExtensionsConfigPanel
extends JPanel {
    private static final long serialVersionUID = -6602264333993164990L;
    private final JButton okButton;
    boolean ok;
    JDialog dialog;
    private final EnumMap<ExtensionObjectType, JCheckBox> extensionGrid = new EnumMap(ExtensionObjectType.class);

    ExtensionsConfigPanel() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(5, 3));
        for (ExtensionObjectType type : ExtensionObjectType.values()) {
            this.extensionGrid.put(type, new JCheckBox(type.toString()));
            panel.add(this.extensionGrid.get(type));
        }
        this.add((Component)panel, "Center");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExtensionsConfigPanel.this.ok = true;
                ExtensionsConfigPanel.this.dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExtensionsConfigPanel.this.dialog.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    boolean showDialog(Component parent, String title, EnumSet<ExtensionObjectType> enabledExtensions) {
        Frame owner;
        this.ok = false;
        for (ExtensionObjectType type : enabledExtensions) {
            this.extensionGrid.get(type).setSelected(true);
        }
        Frame frame = owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setResizable(false);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setTitle(title);
        }
        this.dialog.setLocation(150, 150);
        this.dialog.setVisible(true);
        return this.ok;
    }

    void updateEnabledExtensions(ConfigManager configManager) throws JAXBException, IOException {
        ValidatorConfig validatorConfig = configManager.getValidatorConfig();
        validatorConfig.getEnabledExtensions().clear();
        for (Map.Entry<ExtensionObjectType, JCheckBox> entry : this.extensionGrid.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            validatorConfig.getEnabledExtensions().add(entry.getKey());
        }
        configManager.updateValidatorConfig(validatorConfig);
    }
}

