/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.cli.CliConstants;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.core.VeraPDFException;
import org.verapdf.policy.PolicyChecker;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.ItemDetails;

final class VeraPdfCliProcessor
implements Closeable {
    private static final Logger logger = Logger.getLogger(VeraPdfCliProcessor.class.getCanonicalName());
    private final ConfigManager configManager;
    private final ProcessorConfig processorConfig;
    private final VeraAppConfig appConfig;
    private final boolean isPolicy;
    private final boolean isRecursive;
    private final boolean isServerMode;
    private final File tempMrrFile;
    private final File policyFile;
    private boolean isStdOut = true;
    private boolean appendData = true;
    private String baseDirectory = "";
    private OutputStream os;
    private File tempFile;

    private VeraPdfCliProcessor(VeraCliArgParser args, ConfigManager configManager) throws VeraPDFException {
        File file;
        this.configManager = configManager;
        this.isPolicy = args.isPolicy();
        this.isRecursive = args.isRecurse();
        this.isServerMode = args.isServerMode();
        try {
            this.tempMrrFile = this.isPolicy ? File.createTempFile("mrr", "veraPDF") : null;
        }
        catch (IOException excep) {
            throw new VeraPDFException("Failed to create temporary MRR file", (Throwable)excep);
        }
        this.policyFile = args.getPolicyFile();
        this.appConfig = args.appConfig(configManager.getApplicationConfig());
        this.processorConfig = args.processorConfig(this.appConfig.getProcessType(), this.configManager.getFeaturesConfig(), this.configManager.getPluginsCollectionConfig());
        if (this.configManager.getApplicationConfig().isOverwriteReport() && (file = new File(this.configManager.getApplicationConfig().getReportFile())).exists()) {
            try {
                file.delete();
            }
            catch (SecurityException ex) {
                String message = String.format("Cannot delete existing report file : %s.", file.getPath());
                logger.log(Level.WARNING, message, ex);
            }
        }
    }

    VeraAppConfig getConfig() {
        return this.appConfig;
    }

    ProcessorConfig getProcessorConfig() {
        return this.processorConfig;
    }

    CliConstants.ExitCodes processPaths(List<String> pdfPaths) throws VeraPDFException {
        CliConstants.ExitCodes retStatus = CliConstants.ExitCodes.VALID;
        if (this.isServerMode) {
            try {
                this.tempFile = Files.createTempFile("tempReport", ".xml", new FileAttribute[0]).toFile();
                this.os = new FileOutputStream(this.tempFile);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can't create temp file", e);
            }
        } else {
            this.os = System.out;
        }
        retStatus = pdfPaths.isEmpty() ? this.processStdIn() : this.processFilePaths(pdfPaths);
        if (this.isPolicy) {
            this.applyPolicy();
        }
        return retStatus;
    }

    static VeraPdfCliProcessor createProcessorFromArgs(VeraCliArgParser args, ConfigManager config) throws VeraPDFException {
        return new VeraPdfCliProcessor(args, config);
    }

    private CliConstants.ExitCodes processStdIn() {
        for (String messageLine : CliConstants.MESS_PROC_STDIN) {
            System.out.println(messageLine);
        }
        ItemDetails item = ItemDetails.fromValues((String)"STDIN");
        return this.processStream(item, System.in);
    }

    /*
     * Exception decompiling
     */
    private CliConstants.ExitCodes processFilePaths(List<String> paths) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CliConstants.ExitCodes exitStatusFromSummary(BatchSummary summary) {
        if (summary.getFailedParsingJobs() > 0) {
            return CliConstants.ExitCodes.FAILED_PARSING;
        }
        if (summary.getFailedEncryptedJobs() > 0) {
            return CliConstants.ExitCodes.ENCRYPTED_FILES;
        }
        if (summary.getValidationSummary().getNonCompliantPdfaCount() > 0) {
            return CliConstants.ExitCodes.INVALID;
        }
        return CliConstants.ExitCodes.VALID;
    }

    private CliConstants.ExitCodes processStream(ItemDetails item, InputStream toProcess) {
        CliConstants.ExitCodes retVal = CliConstants.ExitCodes.VALID;
        try (ItemProcessor processor = ProcessorFactory.createProcessor((ProcessorConfig)this.processorConfig);){
            ProcessorResult result = processor.process(item, toProcess);
            OutputStream outputReportStream = this.getReportStream();
            try {
                if (result.isPdf() && !result.isEncryptedPdf()) {
                    ProcessorFactory.resultToXml((ProcessorResult)result, (OutputStream)outputReportStream, (boolean)true);
                    if (!result.getValidationResult().isCompliant()) {
                        retVal = CliConstants.ExitCodes.INVALID;
                    }
                } else {
                    String message = String.format(result.isPdf() ? "%s is an encrypted PDF document." : "%s is not a valid PDF document.", item.getName());
                    outputReportStream.write(message.getBytes());
                    retVal = result.isPdf() ? CliConstants.ExitCodes.ENCRYPTED_FILES : CliConstants.ExitCodes.FAILED_PARSING;
                }
            }
            catch (IOException | JAXBException excep) {
                logger.log(Level.SEVERE, "JAXBException raised when marshalling report.", excep);
                retVal = CliConstants.ExitCodes.JAXB_EXCEPTION;
            }
            if (!this.isStdOut) {
                try {
                    outputReportStream.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Cannot close the report file.", ex);
                }
            }
        }
        catch (IOException excep) {
            logger.log(Level.FINER, "IOException raised when closing ItemProcessor", excep);
        }
        return retVal;
    }

    private OutputStream getReportStream() {
        if (this.isPolicy) {
            if (this.tempMrrFile == null) {
                throw new IllegalStateException("Policy enabled BUT no temp destination");
            }
            try {
                this.isStdOut = false;
                return new FileOutputStream(this.tempMrrFile);
            }
            catch (FileNotFoundException excep) {
                throw new IllegalStateException("Policy enabled BUT no temp destination", excep);
            }
        }
        return this.os;
    }

    private void applyPolicy() throws VeraPDFException {
        File tempPolicyResult;
        try {
            tempPolicyResult = File.createTempFile("policyResult", "veraPDF");
        }
        catch (IOException excep) {
            throw new VeraPDFException("Could not create temporary policy result file.", (Throwable)excep);
        }
        try (FileInputStream mrrIs = new FileInputStream(this.tempMrrFile);
             FileOutputStream policyResultOs = new FileOutputStream(tempPolicyResult);){
            PolicyChecker.applyPolicy((File)this.policyFile, (InputStream)mrrIs, (OutputStream)policyResultOs);
            PolicyChecker.insertPolicyReport((File)tempPolicyResult, (File)this.tempMrrFile, (OutputStream)this.os);
        }
        catch (FileNotFoundException excep) {
            throw new VeraPDFException("Could not find temporary policy result file.", (Throwable)excep);
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing temporary policy file.", excep);
        }
        if (!tempPolicyResult.delete()) {
            tempPolicyResult.deleteOnExit();
        }
    }

    private String constructReportPath(String itemName) {
        String reportPath = "";
        if (!this.configManager.getApplicationConfig().getReportFolder().isEmpty()) {
            Path fileAbsolutePath = Paths.get(itemName, new String[0]);
            String pdfFileName = fileAbsolutePath.getFileName().toString();
            String pdfFileDirectory = fileAbsolutePath.getParent().toString();
            String extension = "." + this.configManager.getApplicationConfig().getFormat().toString();
            String outputFileName = pdfFileName.replace(".pdf", extension);
            String reportFolder = this.configManager.getApplicationConfig().getReportFolder();
            if (pdfFileDirectory.length() > this.baseDirectory.length()) {
                StringBuilder reportFolderBuilder = new StringBuilder();
                reportFolderBuilder.append(reportFolder);
                String subDirectory = pdfFileDirectory.substring(this.baseDirectory.length());
                reportFolderBuilder.append(subDirectory);
                reportFolder = reportFolderBuilder.toString();
                File dir = new File(reportFolder);
                if (!dir.exists()) {
                    try {
                        dir.mkdirs();
                    }
                    catch (SecurityException ex) {
                        logger.log(Level.SEVERE, "Cannot create subdirectories the: " + ex.toString() + "\n");
                        reportFolder = this.configManager.getApplicationConfig().getReportFolder();
                    }
                }
            }
            File reportFile = new File(reportFolder, outputFileName);
            reportPath = reportFile.getAbsolutePath();
            this.appendData = false;
        } else if (!this.configManager.getApplicationConfig().getReportFile().isEmpty()) {
            File reportFile = new File(this.configManager.getApplicationConfig().getReportFile());
            reportPath = reportFile.getAbsolutePath();
            this.appendData = true;
        }
        return reportPath;
    }

    @Override
    public void close() {
        if (this.tempMrrFile != null && !this.tempMrrFile.delete()) {
            this.tempMrrFile.deleteOnExit();
        }
    }

    public File getTempFile() {
        return this.tempFile;
    }
}

