/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli.multithread;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.apps.Applications;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.cli.multithread.BaseCliRunner;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.MultiThreadProcessingHandler;
import org.verapdf.processor.reports.multithread.MultiThreadProcessingHandlerImpl;
import org.verapdf.processor.reports.multithread.writer.ReportWriter;

public class MultiThreadProcessor {
    private static final Logger LOGGER = Logger.getLogger(MultiThreadProcessor.class.getCanonicalName());
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private static final int COEFFICIENT_BUFFER_SIZE = 1024;
    private final Queue<File> filesToProcess;
    private int filesQuantity;
    private File veraPDFStarterPath;
    private List<String> veraPDFParameters;
    private OutputStream os = new BufferedOutputStream(System.out, 524288);
    private OutputStream errorStream = new BufferedOutputStream(System.err, 512);
    private ReportWriter reportWriter;
    private MultiThreadProcessingHandler processingHandler;
    private boolean isFirstReport = true;

    private MultiThreadProcessor(VeraCliArgParser cliArgParser) {
        this.veraPDFStarterPath = this.getVeraPdfStarterFile(cliArgParser);
        this.veraPDFParameters = VeraCliArgParser.getBaseVeraPDFParameters(cliArgParser);
        this.filesToProcess = new ConcurrentLinkedQueue<File>();
        this.filesToProcess.addAll(this.getFiles(cliArgParser.getPdfPaths(), cliArgParser.isRecurse()));
        this.filesQuantity = this.filesToProcess.size();
        FormatOption outputFormat = this.getOutputFormat(cliArgParser.getFormat().getOption());
        this.reportWriter = ReportWriter.newInstance((OutputStream)this.os, (FormatOption)outputFormat, (OutputStream)this.errorStream);
        this.processingHandler = new MultiThreadProcessingHandlerImpl(this.reportWriter);
    }

    public static void process(VeraCliArgParser cliArgParser) {
        MultiThreadProcessor processor = new MultiThreadProcessor(cliArgParser);
        processor.startProcesses(cliArgParser.getNumberOfProcesses());
    }

    private File getVeraPdfStarterFile(VeraCliArgParser cliArgParser) {
        File veraPDFPath = cliArgParser.getVeraCLIPath();
        if (veraPDFPath == null || !veraPDFPath.isFile()) {
            try {
                veraPDFPath = Applications.getVeraScriptFile();
                if (veraPDFPath == null) {
                    throw new IllegalStateException("Can't obtain executable veraPDF CLI script path");
                }
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.SEVERE, "Can't obtain veraPDF CLI script path", e);
            }
        }
        return veraPDFPath;
    }

    private FormatOption getOutputFormat(String outputFormat) {
        return FormatOption.fromOption((String)outputFormat);
    }

    public synchronized void write(ResultStructure result) {
        if (this.isFirstReport) {
            this.processingHandler.startReport();
            this.processingHandler.fillReport(result);
            this.isFirstReport = false;
        } else {
            this.processingHandler.fillReport(result);
        }
        --this.filesQuantity;
        if (this.filesQuantity == 0) {
            this.processingHandler.endReport();
        }
    }

    private List<File> getFiles(List<String> pdfPaths, boolean isRecurse) {
        ArrayList<File> toFilter = new ArrayList<File>(pdfPaths.size());
        pdfPaths.forEach(path -> toFilter.add(new File((String)path)));
        return ApplicationUtils.filterPdfFiles(toFilter, isRecurse);
    }

    private void startProcesses(int numberOfProcesses) {
        int processesQuantity = Math.min(numberOfProcesses, this.filesToProcess.size());
        for (int i = 0; i < processesQuantity; ++i) {
            BaseCliRunner veraPDFRunner = new BaseCliRunner(this, this.veraPDFStarterPath.getAbsolutePath(), this.veraPDFParameters, this.filesToProcess);
            new Thread(veraPDFRunner).start();
        }
    }
}

