/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.Applications;
import org.verapdf.pdfa.Foundries;

class PartnersPanel
extends JPanel {
    private static final long serialVersionUID = -5926089530817358566L;
    private final transient BufferedImage partnersLogo;
    private final Color background;
    private final JLabel consortium;
    private final JLabel preforma;
    private final JLabel version;

    PartnersPanel(String logoName, Color backgroundColor) throws IOException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(logoName);){
            this.partnersLogo = ImageIO.read(is);
        }
        this.background = backgroundColor;
        this.setLayout(null);
        this.consortium = new JLabel("\u00a9 2015-2023 veraPDF Consortium");
        this.consortium.setHorizontalTextPosition(0);
        this.consortium.setFont(new Font(this.consortium.getFont().getName(), this.consortium.getFont().getStyle(), (int)((double)this.consortium.getFont().getSize() * 1.3)));
        Rectangle2D rec = new TextLayout("\u00a9 2015-2023 veraPDF Consortium", this.consortium.getFont(), new FontRenderContext(null, true, true)).getBounds();
        this.consortium.setSize((int)rec.getWidth() + 16, (int)(rec.getHeight() + 4.0));
        this.add(this.consortium);
        this.preforma = new JLabel("Funded by the European Commission\u2019s PREFORMA Project");
        this.preforma.setHorizontalTextPosition(0);
        this.preforma.setFont(new Font(this.preforma.getFont().getName(), this.preforma.getFont().getStyle(), (int)((double)this.preforma.getFont().getSize() * 1.0)));
        Rectangle2D rec2 = new TextLayout("Funded by the European Commission\u2019s PREFORMA Project", this.preforma.getFont(), new FontRenderContext(null, true, true)).getBounds();
        this.preforma.setSize((int)rec2.getWidth() + 8, (int)(rec2.getHeight() + 4.0));
        this.add(this.preforma);
        ReleaseDetails appDetails = Applications.getAppDetails();
        String versionText = "Version: " + appDetails.getVersion() + ", Parser: " + Foundries.defaultInstance().getParserId();
        this.version = new JLabel(versionText);
        this.version.setHorizontalTextPosition(0);
        Rectangle2D recVer = new TextLayout(versionText, this.version.getFont(), new FontRenderContext(null, true, true)).getBounds();
        this.version.setSize((int)(recVer.getWidth() + 8.0), (int)(recVer.getHeight() + 4.0));
        this.add(this.version);
        this.setBackground(backgroundColor);
        int height = (int)((double)this.partnersLogo.getHeight() * 0.6 + (double)(this.consortium.getHeight() * 2) + (double)(this.version.getHeight() * 2) + (double)this.preforma.getHeight());
        this.setPreferredSize(new Dimension(450, height + 8));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int imageHeight = (int)((double)this.partnersLogo.getHeight() * 0.6);
        int imageWidth = (int)((double)this.partnersLogo.getWidth() * 0.6);
        int imageStartY = 8 + this.consortium.getHeight() + this.preforma.getHeight();
        int imageStartX = (this.getWidth() - imageWidth) / 2;
        g.setColor(this.background);
        this.consortium.setLocation((this.getWidth() - this.consortium.getWidth()) / 2, 4);
        this.preforma.setLocation((this.getWidth() - this.preforma.getWidth()) / 2, 4 + this.consortium.getHeight());
        g.drawImage(this.partnersLogo, imageStartX, imageStartY, imageStartX + imageWidth, imageStartY + imageHeight, 0, 0, this.partnersLogo.getWidth(), this.partnersLogo.getHeight(), this);
        this.version.setLocation((this.getWidth() - this.version.getWidth()) / 2, this.getHeight() - this.version.getHeight() - 4);
    }
}

