/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.ScratchFile;

class ScratchFileBuffer
implements RandomAccess {
    private static final int PAGE_SIZE = 4096;
    private ScratchFile scratchFile;
    private RandomAccessFile raFile;
    private final long firstPage;
    private long length = 0L;
    private long currentPage;
    private int positionInPage;
    private long positionInBuffer;

    ScratchFileBuffer(ScratchFile scratchFile) throws IOException {
        scratchFile.checkClosed();
        this.scratchFile = scratchFile;
        this.raFile = scratchFile.getRandomAccessFile();
        this.firstPage = this.createNewPage();
        this.raFile.seek(this.firstPage * 4096L);
        this.raFile.writeLong(-1L);
        this.clear();
    }

    private void checkClosed() throws IOException {
        if (this.scratchFile == null) {
            throw new IOException("Scratch file buffer already closed");
        }
        this.scratchFile.checkClosed();
    }

    @Override
    public long length() throws IOException {
        this.checkClosed();
        return this.length;
    }

    private void growToNewPage() throws IOException {
        long newPage = this.createNewPage();
        if (this.positionInPage != 4088) {
            throw new IOException("Corruption detected in scratch file");
        }
        this.seekToCurrentPositionInFile();
        this.raFile.writeLong(newPage);
        long previousPage = this.currentPage;
        this.currentPage = newPage;
        this.positionInPage = 0;
        this.seekToCurrentPositionInFile();
        this.raFile.writeLong(previousPage);
        this.positionInPage = 8;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        this.seekToCurrentPositionInFile();
        if (this.positionInPage == 4088) {
            this.growToNewPage();
        }
        this.raFile.write(b);
        ++this.positionInPage;
        ++this.positionInBuffer;
        if (this.positionInBuffer > this.length) {
            this.length = this.positionInBuffer;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.seekToCurrentPositionInFile();
        while (len > 0) {
            if (this.positionInPage == 4088) {
                this.growToNewPage();
            }
            int availableSpaceInCurrentPage = 4088 - this.positionInPage;
            int bytesToWrite = Math.min(len, availableSpaceInCurrentPage);
            this.raFile.write(b, off, bytesToWrite);
            off += bytesToWrite;
            len -= bytesToWrite;
            this.positionInPage += bytesToWrite;
            this.positionInBuffer += (long)bytesToWrite;
            if (this.positionInBuffer <= this.length) continue;
            this.length = this.positionInBuffer;
        }
    }

    @Override
    public final void clear() throws IOException {
        this.checkClosed();
        this.length = 0L;
        this.currentPage = this.firstPage;
        this.positionInBuffer = 0L;
        this.positionInPage = 8;
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.positionInBuffer;
    }

    @Override
    public void seek(long seekToPosition) throws IOException {
        this.checkClosed();
        if (seekToPosition > this.length) {
            throw new EOFException();
        }
        if (seekToPosition < this.positionInBuffer) {
            if (this.currentPage != this.firstPage && seekToPosition < this.positionInBuffer / 2L) {
                this.currentPage = this.firstPage;
                this.positionInPage = 8;
                this.positionInBuffer = 0L;
                this.seek(seekToPosition);
            } else {
                while (this.positionInBuffer - seekToPosition > (long)(this.positionInPage - 8)) {
                    long previousPage;
                    this.raFile.seek(this.currentPage * 4096L);
                    this.currentPage = previousPage = this.raFile.readLong();
                    this.positionInBuffer -= (long)(this.positionInPage - 8);
                    this.positionInPage = 4088;
                }
                this.positionInPage = (int)((long)this.positionInPage - (this.positionInBuffer - seekToPosition));
                this.positionInBuffer = seekToPosition;
            }
        } else {
            while (seekToPosition - this.positionInBuffer > (long)(4088 - this.positionInPage)) {
                this.raFile.seek((this.currentPage + 1L) * 4096L - 8L);
                long nextPage = this.raFile.readLong();
                this.positionInBuffer += (long)(4088 - this.positionInPage);
                this.currentPage = nextPage;
                this.positionInPage = 8;
            }
            this.positionInPage = (int)((long)this.positionInPage + (seekToPosition - this.positionInBuffer));
            this.positionInBuffer = seekToPosition;
        }
    }

    @Override
    public boolean isClosed() {
        return this.scratchFile == null;
    }

    @Override
    public int peek() throws IOException {
        int result = this.read();
        if (result != -1) {
            this.rewind(1);
        }
        return result;
    }

    @Override
    public void rewind(int bytes) throws IOException {
        this.seek(this.positionInBuffer - (long)bytes);
    }

    @Override
    public byte[] readFully(int len) throws IOException {
        int count;
        byte[] b = new byte[len];
        int n = 0;
        do {
            if ((count = this.read(b, n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
        return b;
    }

    @Override
    public boolean isEOF() throws IOException {
        this.checkClosed();
        return this.positionInBuffer >= this.length;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return (int)Math.min(this.length - this.positionInBuffer, Integer.MAX_VALUE);
    }

    @Override
    public int read() throws IOException {
        int retv;
        this.checkClosed();
        if (this.positionInBuffer >= this.length) {
            return -1;
        }
        this.seekToCurrentPositionInFile();
        if (this.positionInPage == 4088) {
            this.currentPage = this.raFile.readLong();
            this.positionInPage = 8;
            this.seekToCurrentPositionInFile();
        }
        if ((retv = this.raFile.read()) >= 0) {
            ++this.positionInPage;
            ++this.positionInBuffer;
        }
        return retv;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rdbytes;
        this.checkClosed();
        if (this.positionInBuffer >= this.length) {
            return -1;
        }
        this.seekToCurrentPositionInFile();
        if (this.positionInPage == 4088) {
            this.currentPage = this.raFile.readLong();
            this.positionInPage = 8;
            this.seekToCurrentPositionInFile();
        }
        int totalBytesRead = 0;
        for (len = (int)Math.min((long)len, this.length - this.positionInBuffer); len > 0; len -= rdbytes) {
            int availableInThisPage = 4088 - this.positionInPage;
            rdbytes = this.raFile.read(b, off, Math.min(len, availableInThisPage));
            if (rdbytes < 0) {
                throw new IOException("EOF reached before end of scratch file stream");
            }
            if (rdbytes == availableInThisPage) {
                this.currentPage = this.raFile.readLong();
                this.positionInPage = 8;
                this.seekToCurrentPositionInFile();
            } else {
                this.positionInPage += rdbytes;
            }
            totalBytesRead += rdbytes;
            this.positionInBuffer += (long)rdbytes;
            off += rdbytes;
        }
        return totalBytesRead;
    }

    @Override
    public void close() throws IOException {
        this.scratchFile = null;
        this.raFile = null;
    }

    private void seekToCurrentPositionInFile() throws IOException {
        long positionInFile = this.currentPage * 4096L + (long)this.positionInPage;
        if (this.raFile.getFilePointer() != positionInFile) {
            this.raFile.seek(positionInFile);
        }
    }

    private long createNewPage() throws IOException {
        long fileLen = this.raFile.length();
        if ((fileLen += 4096L) % 4096L > 0L) {
            fileLen += 4096L - fileLen % 4096L;
        }
        this.raFile.setLength(fileLen);
        return fileLen / 4096L - 1L;
    }
}

