/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.digitalsignature;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDPropBuild;

public class PDSignature
implements COSObjectable {
    private final COSDictionary dictionary;
    public static final COSName FILTER_ADOBE_PPKLITE = COSName.ADOBE_PPKLITE;
    public static final COSName FILTER_ENTRUST_PPKEF = COSName.ENTRUST_PPKEF;
    public static final COSName FILTER_CICI_SIGNIT = COSName.CICI_SIGNIT;
    public static final COSName FILTER_VERISIGN_PPKVS = COSName.VERISIGN_PPKVS;
    public static final COSName SUBFILTER_ADBE_X509_RSA_SHA1 = COSName.ADBE_X509_RSA_SHA1;
    public static final COSName SUBFILTER_ADBE_PKCS7_DETACHED = COSName.ADBE_PKCS7_DETACHED;
    public static final COSName SUBFILTER_ETSI_CADES_DETACHED = COSName.getPDFName("ETSI.CAdES.detached");
    public static final COSName SUBFILTER_ADBE_PKCS7_SHA1 = COSName.ADBE_PKCS7_SHA1;

    public PDSignature() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.TYPE, (COSBase)COSName.SIG);
    }

    public PDSignature(COSDictionary dict) {
        this.dictionary = dict;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public void setType(COSName type) {
        this.dictionary.setItem(COSName.TYPE, (COSBase)type);
    }

    public void setFilter(COSName filter) {
        this.dictionary.setItem(COSName.FILTER, (COSBase)filter);
    }

    public void setSubFilter(COSName subfilter) {
        this.dictionary.setItem(COSName.SUB_FILTER, (COSBase)subfilter);
    }

    public void setName(String name) {
        this.dictionary.setString(COSName.NAME, name);
    }

    public void setLocation(String location) {
        this.dictionary.setString(COSName.LOCATION, location);
    }

    public void setReason(String reason) {
        this.dictionary.setString(COSName.REASON, reason);
    }

    public void setContactInfo(String contactInfo) {
        this.dictionary.setString(COSName.CONTACT_INFO, contactInfo);
    }

    public void setSignDate(Calendar cal) {
        this.dictionary.setDate(COSName.M, cal);
    }

    public String getFilter() {
        return this.dictionary.getNameAsString(COSName.FILTER);
    }

    public String getSubFilter() {
        return this.dictionary.getNameAsString(COSName.SUB_FILTER);
    }

    public String getName() {
        return this.dictionary.getString(COSName.NAME);
    }

    public String getLocation() {
        return this.dictionary.getString(COSName.LOCATION);
    }

    public String getReason() {
        return this.dictionary.getString(COSName.REASON);
    }

    public String getContactInfo() {
        return this.dictionary.getString(COSName.CONTACT_INFO);
    }

    public Calendar getSignDate() {
        return this.dictionary.getDate(COSName.M);
    }

    public void setByteRange(int[] range) {
        if (range.length != 4) {
            return;
        }
        COSArray ary = new COSArray();
        for (int i : range) {
            ary.add(COSInteger.get(i));
        }
        this.dictionary.setItem(COSName.BYTERANGE, (COSBase)ary);
    }

    public int[] getByteRange() {
        COSArray byteRange = (COSArray)this.dictionary.getDictionaryObject(COSName.BYTERANGE);
        int[] ary = new int[byteRange.size()];
        for (int i = 0; i < ary.length; ++i) {
            ary[i] = byteRange.getInt(i);
        }
        return ary;
    }

    public byte[] getContents() {
        COSString string = (COSString)this.dictionary.getDictionaryObject(COSName.CONTENTS);
        return string.getBytes();
    }

    public byte[] getContents(InputStream pdfFile) throws IOException {
        int[] byteRange = this.getByteRange();
        int begin = byteRange[0] + byteRange[1] + 1;
        int end = byteRange[2] - begin;
        return this.getContents(new COSFilterInputStream(pdfFile, new int[]{begin, end}));
    }

    public byte[] getContents(byte[] pdfFile) throws IOException {
        int[] byteRange = this.getByteRange();
        int begin = byteRange[0] + byteRange[1] + 1;
        int end = byteRange[2] - begin;
        return this.getContents(new COSFilterInputStream(pdfFile, new int[]{begin, end}));
    }

    private byte[] getContents(COSFilterInputStream fis) throws IOException {
        int c;
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((c = fis.read(buffer)) != -1) {
            if (buffer[0] == 60 || buffer[0] == 40) {
                byteOS.write(buffer, 1, c);
                continue;
            }
            if (buffer[c - 1] == 62 || buffer[c - 1] == 41) {
                byteOS.write(buffer, 0, c - 1);
                continue;
            }
            byteOS.write(buffer, 0, c);
        }
        fis.close();
        return COSString.parseHex(byteOS.toString("ISO-8859-1")).getBytes();
    }

    public void setContents(byte[] bytes) {
        COSString string = new COSString(bytes);
        string.setForceHexForm(true);
        this.dictionary.setItem(COSName.CONTENTS, (COSBase)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSignedContent(InputStream pdfFile) throws IOException {
        try (FilterInputStream fis = null;){
            fis = new COSFilterInputStream(pdfFile, this.getByteRange());
            byte[] byArray = ((COSFilterInputStream)fis).toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSignedContent(byte[] pdfFile) throws IOException {
        try (FilterInputStream fis = null;){
            fis = new COSFilterInputStream(pdfFile, this.getByteRange());
            byte[] byArray = ((COSFilterInputStream)fis).toByteArray();
            return byArray;
        }
    }

    public PDPropBuild getPropBuild() {
        PDPropBuild propBuild = null;
        COSDictionary propBuildDic = (COSDictionary)this.dictionary.getDictionaryObject(COSName.PROP_BUILD);
        if (propBuildDic != null) {
            propBuild = new PDPropBuild(propBuildDic);
        }
        return propBuild;
    }

    public void setPropBuild(PDPropBuild propBuild) {
        this.dictionary.setItem(COSName.PROP_BUILD, (COSObjectable)propBuild);
    }
}

