/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.util;

import java.awt.Image;
import java.io.IOException;
import java.util.List;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.content.PreflightStreamEngine;

public class PreflightType3Stream
extends PreflightStreamEngine {
    private final PDType3CharProc charProc;
    private boolean firstOperator = true;
    private float width = 0.0f;
    private PDInlineImage image = null;
    private BoundingBox box = null;

    public PreflightType3Stream(PreflightContext context, PDPage page, PDType3CharProc charProc) {
        super(context, page);
        this.charProc = charProc;
    }

    public void showType3Character(PDType3CharProc charProc) throws IOException {
        this.processChildStream(charProc, new PDPage());
    }

    public Image createImage() throws IOException {
        this.showType3Character(this.charProc);
        return this.image.getImage();
    }

    protected void processOperator(Operator operator, List operands) throws IOException {
        super.processOperator(operator, (List<COSBase>)operands);
        String operation = operator.getName();
        if (operation.equals("BI")) {
            this.image = new PDInlineImage(operator.getImageParameters(), operator.getImageData(), this.getResources());
            this.validateImageFilter(operator);
            this.validateImageColorSpace(operator);
        }
        if (operation.equals("d0")) {
            this.checkType3FirstOperator(operands);
        } else if (operation.equals("d1")) {
            COSNumber llx = (COSNumber)operands.get(2);
            COSNumber lly = (COSNumber)operands.get(3);
            COSNumber urx = (COSNumber)operands.get(4);
            COSNumber ury = (COSNumber)operands.get(5);
            this.box = new BoundingBox();
            this.box.setLowerLeftX(llx.floatValue());
            this.box.setLowerLeftY(lly.floatValue());
            this.box.setUpperRightX(urx.floatValue());
            this.box.setUpperRightY(ury.floatValue());
            this.checkType3FirstOperator(operands);
        }
        this.checkColorOperators(operation);
        this.validateRenderingIntent(operator, operands);
        this.checkSetColorSpaceOperators(operator, operands);
        this.validateNumberOfGraphicStates(operator);
        this.firstOperator = false;
    }

    private void checkType3FirstOperator(List arguments) throws IOException {
        if (!this.firstOperator) {
            throw new IOException("Type3 CharProc : First operator must be d0 or d1");
        }
        Object obj = arguments.get(0);
        if (obj instanceof Number) {
            this.width = ((Number)obj).intValue();
        } else if (obj instanceof COSNumber) {
            this.width = ((COSNumber)obj).floatValue();
        } else {
            throw new IOException("Unexpected argument type. Expected : COSInteger or Number / Received : " + obj.getClass().getName());
        }
    }

    public float getWidth() {
        return this.width;
    }
}

