/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.verapdf.features.objects.ImageXObjectFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBImageXObjectFeaturesObjectAdapter
implements ImageXObjectFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBImageXObjectFeaturesObjectAdapter.class.getCanonicalName());
    private PDImageXObjectProxy imageXObject;
    private String id;
    private String colorSpaceChild;
    private String maskChild;
    private String sMaskChild;
    private Set<String> alternatesChild;
    private List<String> errors;
    private List<String> filterNames;

    public PBImageXObjectFeaturesObjectAdapter(PDImageXObjectProxy imageXObject, String id, String colorSpaceChild, String maskChild, String sMaskChild, Set<String> alternatesChild) {
        this.imageXObject = imageXObject;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
        this.maskChild = maskChild;
        this.sMaskChild = sMaskChild;
        this.alternatesChild = alternatesChild;
        this.errors = new ArrayList<String>();
        this.filterNames = new ArrayList<String>();
        this.init();
    }

    private void init() {
        try {
            List<COSName> filters = this.imageXObject.getStream().getFilters();
            if (filters != null) {
                for (COSName filter : filters) {
                    this.filterNames.add(filter.getName());
                }
            }
        }
        catch (IOException e) {
            this.errors.add("Can't get image stream filters");
            LOGGER.log(Level.INFO, e.getMessage());
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Long getWidth() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getWidth());
    }

    @Override
    public Long getHeight() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getHeight());
    }

    @Override
    public String getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    @Override
    public Long getBitsPerComponent() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getBitsPerComponent());
    }

    @Override
    public boolean getImageMask() {
        return this.imageXObject == null ? false : this.imageXObject.isStencil();
    }

    @Override
    public String getMaskChild() {
        return this.maskChild;
    }

    @Override
    public boolean isInterpolate() {
        return this.imageXObject == null ? false : this.imageXObject.getInterpolate();
    }

    @Override
    public Set<String> getAlternatesChild() {
        return Collections.unmodifiableSet(this.alternatesChild);
    }

    @Override
    public String getSMaskChild() {
        return this.sMaskChild;
    }

    @Override
    public Long getStructParent() {
        return this.imageXObject == null ? null : Long.valueOf(this.imageXObject.getStructParent());
    }

    @Override
    public List<String> getFilters() {
        return Collections.unmodifiableList(this.filterNames);
    }

    @Override
    public InputStream getMetadata() {
        if (this.imageXObject != null) {
            return PBAdapterHelper.getMetadataStream(this.imageXObject.getMetadata());
        }
        return null;
    }

    @Override
    public InputStream getRawStreamData() {
        if (this.imageXObject != null) {
            try {
                if (this.imageXObject.getStream() != null && this.imageXObject.getStream().getStream() != null) {
                    return this.imageXObject.getStream().getStream().getFilteredStream();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.imageXObject != null;
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }

    @Override
    public List<ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter> getFilterAdapters() {
        if (this.imageXObject != null && this.imageXObject.getCOSObject() != null) {
            COSBase base = this.imageXObject.getCOSStream().getDictionaryObject(COSName.DECODE_PARMS);
            ArrayList<PBStreamFilterAdapter> res = new ArrayList<PBStreamFilterAdapter>();
            if (base instanceof COSDictionary) {
                res.add(new PBStreamFilterAdapter(base));
            } else if (base instanceof COSArray) {
                for (COSBase baseElem : (COSArray)base) {
                    if (baseElem instanceof COSDictionary) {
                        res.add(new PBStreamFilterAdapter(baseElem));
                        continue;
                    }
                    res.add(null);
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    class PBStreamFilterAdapter
    implements ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter {
        private COSDictionary base;

        public PBStreamFilterAdapter(COSBase base) {
            this.base = base == null ? new COSDictionary() : (COSDictionary)base;
        }

        @Override
        public Long getCCITTK() {
            COSBase k = this.base.getDictionaryObject(COSName.K);
            return k instanceof COSInteger ? Long.valueOf(((COSInteger)k).longValue()) : null;
        }

        @Override
        public boolean getCCITTEndOfLine() {
            COSBase colors = this.base.getDictionaryObject(COSName.COLORS);
            return colors instanceof COSBoolean ? ((COSBoolean)colors).getValue() : false;
        }

        @Override
        public boolean getCCITTEncodedByteAlign() {
            COSBase bitsPerComponent = this.base.getDictionaryObject(COSName.BITS_PER_COMPONENT);
            return bitsPerComponent instanceof COSBoolean ? ((COSBoolean)bitsPerComponent).getValue() : false;
        }

        @Override
        public Long getCCITTColumns() {
            COSBase columns = this.base.getDictionaryObject(COSName.COLUMNS);
            return columns instanceof COSInteger ? Long.valueOf(((COSInteger)columns).longValue()) : null;
        }

        @Override
        public Long getCCITTRows() {
            COSBase rows = this.base.getDictionaryObject(COSName.ROWS);
            return rows instanceof COSInteger ? Long.valueOf(((COSInteger)rows).longValue()) : null;
        }

        @Override
        public boolean getCCITTEndOfBlock() {
            COSBase endOfBlock = this.base.getDictionaryObject(COSName.getPDFName("EndOfBlock"));
            return endOfBlock instanceof COSBoolean ? ((COSBoolean)endOfBlock).getValue() : true;
        }

        @Override
        public boolean getCCITTBlackIs1() {
            COSBase blackIs1 = this.base.getDictionaryObject(COSName.BLACK_IS_1);
            return blackIs1 instanceof COSBoolean ? ((COSBoolean)blackIs1).getValue() : false;
        }

        @Override
        public Long getCCITTDamagedRowsBeforeError() {
            COSBase damgedRowsBeforeError = this.base.getDictionaryObject(COSName.getPDFName("DamagedRowsBeforeError"));
            return damgedRowsBeforeError instanceof COSInteger ? Long.valueOf(((COSInteger)damgedRowsBeforeError).longValue()) : null;
        }

        @Override
        public Long getDCTColorTransform() {
            COSBase colorTransform = this.base.getDictionaryObject(COSName.getPDFName("ColorTransform"));
            return colorTransform instanceof COSInteger ? Long.valueOf(((COSInteger)colorTransform).longValue()) : null;
        }

        @Override
        public Long getLZWEarlyChange() {
            COSBase earlyChange = this.base.getDictionaryObject(COSName.EARLY_CHANGE);
            return earlyChange instanceof COSInteger ? Long.valueOf(((COSInteger)earlyChange).longValue()) : null;
        }

        @Override
        public Long getFlatePredictor() {
            COSBase predictor = this.base.getDictionaryObject(COSName.PREDICTOR);
            return predictor instanceof COSInteger ? Long.valueOf(((COSInteger)predictor).longValue()) : null;
        }

        @Override
        public Long getFlateColors() {
            COSBase colors = this.base.getDictionaryObject(COSName.COLORS);
            return colors instanceof COSInteger ? Long.valueOf(((COSInteger)colors).longValue()) : null;
        }

        @Override
        public Long getFlateBitsPerComponent() {
            COSBase bitsPerComponent = this.base.getDictionaryObject(COSName.BITS_PER_COMPONENT);
            return bitsPerComponent instanceof COSInteger ? Long.valueOf(((COSInteger)bitsPerComponent).longValue()) : null;
        }

        @Override
        public Long getFlateColumns() {
            return ((COSInteger)this.base.getDictionaryObject(COSName.COLUMNS)).longValue();
        }

        @Override
        public InputStream getJBIG2Global() {
            try {
                if (this.base.getDictionaryObject(COSName.JBIG2_GLOBALS) instanceof COSStream) {
                    return ((COSStream)this.base.getDictionaryObject(COSName.JBIG2_GLOBALS)).getUnfilteredStream();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getMessage());
            }
            return null;
        }

        @Override
        public boolean hasCryptFilter() {
            return !COSName.IDENTITY.equals(this.base.getCOSName(COSName.NAME));
        }
    }
}

