/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.font;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.impl.pb.pd.font.PBoxPDTrueTypeFont;
import org.verapdf.model.impl.pb.pd.font.PBoxPDType0Font;
import org.verapdf.model.impl.pb.pd.font.PBoxPDType1Font;
import org.verapdf.model.impl.pb.pd.font.PBoxPDType3Font;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public final class FontFactory {
    public static final String TYPE_0 = "Type0";
    public static final String TYPE_1 = "Type1";
    public static final String MM_TYPE_1 = "MMType1";
    public static final String TYPE_3 = "Type3";
    public static final String TRUE_TYPE = "TrueType";
    public static final String CID_FONT_TYPE_2 = "CIDFontType2";

    private FontFactory() {
    }

    public static org.verapdf.model.pdlayer.PDFont parseFont(PDFont pdfboxFont, RenderingMode renderingMode, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        if (pdfboxFont == null) {
            return null;
        }
        switch (pdfboxFont.getSubType()) {
            case "Type0": {
                return new PBoxPDType0Font(pdfboxFont, renderingMode, document, flavour);
            }
            case "Type1": 
            case "MMType1": {
                if (pdfboxFont instanceof PDType1Font) {
                    return new PBoxPDType1Font((PDType1Font)pdfboxFont, renderingMode, flavour);
                }
                if (pdfboxFont instanceof PDType1CFont) {
                    return new PBoxPDType1Font((PDType1CFont)pdfboxFont, renderingMode, flavour);
                }
            }
            case "Type3": {
                PDResources fontResources = ((PDType3Font)pdfboxFont).getResources();
                PDInheritableResources pdResources = resources.getExtendedResources(fontResources);
                return new PBoxPDType3Font(pdfboxFont, renderingMode, pdResources, document, flavour);
            }
            case "TrueType": {
                return new PBoxPDTrueTypeFont((PDTrueTypeFont)pdfboxFont, renderingMode);
            }
        }
        return null;
    }

    public static org.verapdf.model.pdlayer.PDFont parseFont(PDFont pdfboxFont, PDDocument document, PDFAFlavour flavour) {
        return FontFactory.parseFont(pdfboxFont, RenderingMode.FILL, PDInheritableResources.EMPTY_EXTENDED_RESOURCES, document, flavour);
    }
}

