/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosArray;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosArray
extends PBCosObject
implements CosArray {
    public static final String COS_ARRAY_TYPE = "CosArray";
    public static final String ELEMENTS = "elements";
    private final int size;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBCosArray(COSArray array, PDDocument document, PDFAFlavour flavour) {
        this(array, COS_ARRAY_TYPE, document, flavour);
    }

    public PBCosArray(COSArray array, String type, PDDocument document, PDFAFlavour flavour) {
        super(array, type);
        this.size = array.size();
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public Long getsize() {
        return this.size;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (link.equals(ELEMENTS)) {
            return this.getElements();
        }
        return super.getLinkedObjects(link);
    }

    private List<CosObject> getElements() {
        ArrayList<CosObject> list = new ArrayList<CosObject>(this.getsize().intValue());
        for (COSBase base : (COSArray)this.baseObject) {
            if (base == null) continue;
            list.add(PBCosArray.getFromValue(base, this.document, this.flavour));
        }
        return Collections.unmodifiableList(list);
    }
}

