/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.flavours;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.verapdf.pdfa.flavours.PDFAFlavours;

public enum PDFAFlavour {
    NO_FLAVOUR(Specification.NO_STANDARD, Level.NO_LEVEL),
    PDFA_1_A(Specification.ISO_19005_1, Level.A),
    PDFA_1_B(Specification.ISO_19005_1, Level.B),
    PDFA_2_A(Specification.ISO_19005_2, Level.A),
    PDFA_2_B(Specification.ISO_19005_2, Level.B),
    PDFA_2_U(Specification.ISO_19005_2, Level.U),
    PDFA_3_A(Specification.ISO_19005_3, Level.A),
    PDFA_3_B(Specification.ISO_19005_3, Level.B),
    PDFA_3_U(Specification.ISO_19005_3, Level.U),
    PDFA_4(Specification.ISO_19005_4, Level.NO_LEVEL),
    PDFA_4_F(Specification.ISO_19005_4, Level.F),
    PDFA_4_E(Specification.ISO_19005_4, Level.E),
    PDFUA_1(Specification.ISO_14289_1, Level.NO_LEVEL),
    PDFUA_2(Specification.ISO_14289_2, Level.NO_LEVEL),
    WTPDF_1_0_REUSE(Specification.WTPDF_1_0, Level.REUSE),
    WTPDF_1_0_ACCESSIBILITY(Specification.WTPDF_1_0, Level.ACCESSIBILITY),
    NO_ARLINGTON_FLAVOUR(Specification.NO_STANDARD, Level.A),
    ARLINGTON1_0(Specification.PDF_1_0, Level.NO_LEVEL),
    ARLINGTON1_1(Specification.PDF_1_1, Level.NO_LEVEL),
    ARLINGTON1_2(Specification.PDF_1_2, Level.NO_LEVEL),
    ARLINGTON1_3(Specification.PDF_1_3, Level.NO_LEVEL),
    ARLINGTON1_4(Specification.PDF_1_4, Level.NO_LEVEL),
    ARLINGTON1_5(Specification.PDF_1_5, Level.NO_LEVEL),
    ARLINGTON1_6(Specification.PDF_1_6, Level.NO_LEVEL),
    ARLINGTON1_7(Specification.ISO_32000_1_7, Level.NO_LEVEL),
    ARLINGTON2_0(Specification.ISO_32000_2_0, Level.NO_LEVEL),
    WCAG_2_1(Specification.WCAG_2_1, Level.NO_LEVEL),
    WCAG_2_2(Specification.WCAG_2_2, Level.NO_LEVEL);

    private static final Map<String, PDFAFlavour> FLAVOUR_LOOKUP;
    private final Specification part;
    private final Level level;
    private final String id;

    private PDFAFlavour(Specification standard, Level level) {
        this(PDFAFlavour.getID(standard, level), standard, level);
    }

    private PDFAFlavour(String id, Specification standard, Level level) {
        this.part = standard;
        this.level = level;
        this.id = id;
    }

    private static String getID(Specification standard, Level level) {
        String levelString = level.getCode().length() > 1 ? level.getCode().substring(0, 1) : level.getCode();
        StringBuilder id = new StringBuilder(PDFAFlavour.getPrefix(standard) + standard.getPartNumber());
        if (SpecificationFamily.ARLINGTON == standard.family) {
            id.append(".").append(standard.getSubpartNumber());
        }
        id.append(levelString.toLowerCase());
        return id.toString();
    }

    private static String getPrefix(Specification standard) {
        if (SpecificationFamily.PDF_UA == standard.family) {
            return "ua";
        }
        if (SpecificationFamily.WCAG == standard.family) {
            return "wcag";
        }
        if (SpecificationFamily.WTPDF == standard.family) {
            return "wt";
        }
        if (SpecificationFamily.ARLINGTON == standard.family) {
            return "arlington";
        }
        return "";
    }

    public final Specification getPart() {
        return this.part;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final String getId() {
        return this.id;
    }

    public final String toString() {
        return this.id;
    }

    public static PDFAFlavour byFlavourId(String flavourId) {
        PDFAFlavour flavour = FLAVOUR_LOOKUP.get(flavourId.toLowerCase());
        if (flavour == null) {
            flavour = NO_FLAVOUR;
        }
        return flavour;
    }

    public static PDFAFlavour fromString(String toParse) {
        for (String id : PDFAFlavour.getFlavourIds()) {
            if (!toParse.toLowerCase().contains(id)) continue;
            return PDFAFlavour.byFlavourId(id);
        }
        return NO_FLAVOUR;
    }

    public static Set<String> getFlavourIds() {
        return FLAVOUR_LOOKUP.keySet();
    }

    static {
        FLAVOUR_LOOKUP = new HashMap<String, PDFAFlavour>();
        for (PDFAFlavour flavour : PDFAFlavour.values()) {
            FLAVOUR_LOOKUP.put(flavour.id, flavour);
        }
    }

    public static enum Specification {
        NO_STANDARD(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.NONE, 0, PDFAFlavours.NONE_SUBPART, "", ""),
        ISO_14289_1(IsoStandardSeries.ISO_14289, PDFSpecification.ISO_32000_1_7, SpecificationFamily.PDF_UA, 1, PDFAFlavours.NONE_SUBPART, "2014", "Use of ISO 32000-1 (PDF/UA-1)"),
        ISO_14289_2(IsoStandardSeries.ISO_14289, PDFSpecification.ISO_32000_2_0, SpecificationFamily.PDF_UA, 2, PDFAFlavours.NONE_SUBPART, "2024", "Use of ISO 32000-2 (PDF/UA-2)"),
        WTPDF_1_0(IsoStandardSeries.NO_SERIES, PDFSpecification.ISO_32000_2_0, SpecificationFamily.WTPDF, 1, 0, "2024", "Using Tagged PDF for Accessibility and Reuse in PDF 2.0"),
        ISO_19005_1(IsoStandardSeries.ISO_19005, PDFSpecification.PDF_REFERENCE_1_4, SpecificationFamily.PDF_A, 1, PDFAFlavours.NONE_SUBPART, "2005", "Use of PDF 1.4"),
        ISO_19005_2(IsoStandardSeries.ISO_19005, PDFSpecification.ISO_32000_1_7, SpecificationFamily.PDF_A, 2, PDFAFlavours.NONE_SUBPART, "2011", "Use of ISO 32000-1"),
        ISO_19005_3(IsoStandardSeries.ISO_19005, PDFSpecification.ISO_32000_1_7, SpecificationFamily.PDF_A, 3, PDFAFlavours.NONE_SUBPART, "2012", "Use of ISO 32000-1 with support for embedded files"),
        ISO_19005_4(IsoStandardSeries.ISO_19005, PDFSpecification.ISO_32000_2_0, SpecificationFamily.PDF_A, 4, PDFAFlavours.NONE_SUBPART, "2020", "Use of ISO 32000-2"),
        PDF_1_0(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 0, "1993", "Based on PDF 1.0"),
        PDF_1_1(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 1, "1996", "Based on PDF 1.1"),
        PDF_1_2(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 2, "1996", "Based on PDF 1.2"),
        PDF_1_3(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 3, "2000", "Based on PDF 1.3"),
        PDF_1_4(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 4, "2001", "Based on PDF 1.4"),
        PDF_1_5(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 5, "2003", "Based on PDF 1.5"),
        PDF_1_6(IsoStandardSeries.NO_SERIES, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 6, "2004", "Based on PDF 1.6"),
        ISO_32000_1_7(IsoStandardSeries.ISO_32000, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 1, 7, "2008", "Based on PDF 1.7"),
        ISO_32000_2_0(IsoStandardSeries.ISO_32000, PDFSpecification.NO_SPECIFICATION, SpecificationFamily.ARLINGTON, 2, 0, "2020", "Based on PDF 2.0"),
        ISO_32005(IsoStandardSeries.ISO_32005, PDFSpecification.ISO_32000_2_0, SpecificationFamily.TAGGED_PDF, PDFAFlavours.NONE_PART, PDFAFlavours.NONE_SUBPART, "2023", "Document management -- Portable document format -- PDF 1.7 and 2.0 structure namespace inclusion in ISO 32000-2"),
        WCAG_2_1(IsoStandardSeries.NO_SERIES, PDFSpecification.ISO_32000_2_0, SpecificationFamily.WCAG, 2, 1, "2018", "Web Content Accessibility Guidelines 2.1"),
        WCAG_2_2(IsoStandardSeries.NO_SERIES, PDFSpecification.ISO_32000_2_0, SpecificationFamily.WCAG, 2, 2, "2023", "Web Content Accessibility Guidelines 2.2");

        private final IsoStandardSeries series;
        private final PDFSpecification pdfSpecification;
        private final Integer partNumber;
        private final Integer subpartNumber;
        private final String id;
        private final String year;
        private final SpecificationFamily family;
        private final String name;
        private final String description;

        private Specification(IsoStandardSeries series, PDFSpecification pdfSpecification, SpecificationFamily family, Integer partNumber, Integer subpartNumber, String year, String description) {
            this.series = series;
            this.pdfSpecification = pdfSpecification;
            this.partNumber = partNumber;
            this.subpartNumber = subpartNumber;
            this.year = year;
            this.description = description;
            this.family = family;
            this.name = (Object)((Object)family) + "-" + this.getPartNumber();
            this.id = this.calculateID();
        }

        private String calculateID() {
            if (SpecificationFamily.ARLINGTON == this.family && this.partNumber < 7) {
                return "PDF Reference " + this.partNumber + "." + this.subpartNumber;
            }
            if (this.series == IsoStandardSeries.ISO_32000) {
                return this.series.getName() + "-" + this.partNumber + ":" + this.getYear();
            }
            StringBuilder id = new StringBuilder();
            if (SpecificationFamily.WTPDF == this.getFamily() || SpecificationFamily.WCAG == this.getFamily()) {
                id.append(this.getFamily().getFamily());
                if (this.getPartNumber() != null) {
                    id.append(this.getPartNumber());
                    if (this.getSubpartNumber() != null) {
                        id.append(".").append(this.getSubpartNumber());
                    }
                }
            } else {
                id.append(this.getSeries().getName());
                if (this.getPartNumber() != null) {
                    id.append("-").append(this.getPartNumber());
                    if (this.getSubpartNumber() != null) {
                        id.append(".").append(this.getSubpartNumber());
                    }
                }
                if (this.getYear() != null) {
                    id.append(":").append(this.getYear());
                }
            }
            return id.toString();
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        public final Integer getSubpartNumber() {
            return this.subpartNumber;
        }

        public final String getId() {
            return this.id;
        }

        public final String getYear() {
            return this.year;
        }

        public final String getName() {
            return this.name;
        }

        public final SpecificationFamily getFamily() {
            return this.family;
        }

        public PDFSpecification getPdfSpecification() {
            return this.pdfSpecification;
        }

        public String getDescription() {
            return this.description;
        }

        public IsoStandardSeries getSeries() {
            return this.series;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum Level {
        NO_LEVEL("", ""),
        A("a", "accessible"),
        B("b", "basic"),
        U("u", "unicode"),
        F("f", "embedded files"),
        E("e", "engineering"),
        ACCESSIBILITY("Accessibility", "Accessibility"),
        REUSE("Reuse", "Reuse");

        private final String code;
        private final String name;

        private Level(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public final String getCode() {
            return this.code;
        }

        public final String getName() {
            return this.name;
        }
    }

    public static enum SpecificationFamily {
        NONE(""),
        PDF_A("PDF/A"),
        PDF_UA("PDF/UA"),
        WTPDF("WTPDF"),
        TAGGED_PDF("Tagged PDF"),
        ARLINGTON("Arlington".toUpperCase()),
        WCAG("WCAG");

        private final String family;

        private SpecificationFamily(String family) {
            this.family = family;
        }

        public String getFamily() {
            return this.family;
        }
    }

    public static enum PDFSpecification {
        NO_SPECIFICATION,
        PDF_REFERENCE_1_4,
        ISO_32000_1_7,
        ISO_32000_2_0;

    }

    public static enum IsoStandardSeries {
        NO_SERIES(0, ""),
        ISO_14289(14289, "Document management applications \u2014 Electronic document file format enhancement for accessibility"),
        ISO_19005(19005, "Document management -- Electronic document file format for long-term preservation"),
        ISO_32000(32000, "Document management -- Portable document format"),
        ISO_32000_1(320001, "Document management -- Portable document format"),
        ISO_32000_2(320002, "Document management -- Portable document format"),
        ISO_32005(32005, "Document management -- Portable document format -- PDF 1.7 and 2.0 structure namespace inclusion in ISO 32000-2");

        private final int id;
        private final String name;
        private final String description;

        private IsoStandardSeries(int id, String description) {
            this.id = id;
            this.name = "ISO " + this.getId();
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getName() + " " + this.getDescription();
        }
    }
}

