/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.validation.profiles.Reference;

@XmlRootElement(name="reference")
final class ReferenceImpl
implements Reference {
    private static final ReferenceImpl DEFAULT = new ReferenceImpl();
    @XmlAttribute
    private final String specification;
    @XmlAttribute
    private final String clause;

    private ReferenceImpl() {
        this("specification", "clause");
    }

    private ReferenceImpl(String specification, String clause) {
        this.specification = specification;
        this.clause = clause;
    }

    @Override
    public String getSpecification() {
        return this.specification;
    }

    @Override
    public String getClause() {
        return this.clause;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clause == null ? 0 : this.clause.hashCode());
        result = 31 * result + (this.specification == null ? 0 : this.specification.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.clause == null ? other.getClause() != null : !this.clause.equals(other.getClause())) {
            return false;
        }
        return !(this.specification == null ? other.getSpecification() != null : !this.specification.equals(other.getSpecification()));
    }

    public final String toString() {
        return "Reference [specification=" + this.specification + ", clause=" + this.clause + "]";
    }

    static Reference defaultInstance() {
        return DEFAULT;
    }

    static Reference fromValues(String specification, String clause) {
        return new ReferenceImpl(specification, clause);
    }

    static class Adapter
    extends XmlAdapter<ReferenceImpl, Reference> {
        Adapter() {
        }

        public Reference unmarshal(ReferenceImpl refImpl) {
            return refImpl;
        }

        public ReferenceImpl marshal(Reference ref) {
            return (ReferenceImpl)ref;
        }
    }
}

