/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.report.XmpHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@XmlRootElement
public class FeaturesNode {
    private static final Logger LOGGER = Logger.getLogger(FeaturesNode.class.getName());
    private static final int XD7FF = 55295;
    private static final int XE000 = 57344;
    private static final int XFFFD = 65533;
    private static final int X10000 = 65536;
    private static final int X10FFFF = 0x10FFFF;
    private static final int SP = 32;
    private static final int HT = 9;
    private static final int LF = 10;
    private static final int CR = 13;
    @XmlAnyAttribute
    private final Map<QName, Object> attributes;
    @XmlMixed
    private final List<Object> children;

    private FeaturesNode(Map<QName, Object> attributes, List<Object> children) {
        this.attributes = attributes;
        this.children = children;
    }

    private FeaturesNode() {
        this(null, null);
    }

    static FeaturesNode fromValues(FeatureExtractionResult collection, FeatureObjectType ... types) {
        ArrayList<Object> qChildren = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        for (FeatureObjectType type : types) {
            List<String> errors;
            List<FeatureTreeNode> children = collection.getFeatureTreesForType(type);
            if (children != null) {
                for (FeatureTreeNode entry : children) {
                    qChildren.add(new JAXBElement(new QName(entry.getName()), FeaturesNode.class, (Object)FeaturesNode.fromValues(entry, collection)));
                }
            }
            if ((errors = collection.getErrorsForType(type)) == null || errors.isEmpty()) continue;
            int i = 0;
            if (builder.toString().isEmpty()) {
                builder.append(errors.get(0));
                i = 1;
            }
            while (i < errors.size()) {
                builder.append(", ").append(errors.get(i));
                ++i;
            }
        }
        HashMap<QName, Object> attr = new HashMap<QName, Object>();
        if (!builder.toString().isEmpty()) {
            attr.put(new QName("errorId"), builder.toString());
        }
        if (qChildren.isEmpty() && attr.isEmpty()) {
            return null;
        }
        return new FeaturesNode(attr, qChildren);
    }

    static FeaturesNode fromValues(FeatureTreeNode node, FeatureExtractionResult collection) {
        if (node == null) {
            throw new IllegalArgumentException("Argument node cannot be null");
        }
        HashMap<QName, Object> qAttributes = new HashMap<QName, Object>();
        for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
            qAttributes.put(new QName(entry.getKey()), FeaturesNode.replaceInvalidCharacters(entry.getValue()));
        }
        ArrayList<Object> qChildren = new ArrayList<Object>();
        if (node.getValue() != null) {
            if (node.isMetadataNode()) {
                try {
                    JAXBElement<FeaturesNode> metadata = FeaturesNode.fromXmp(node);
                    qChildren.add(metadata);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    LOGGER.log(Level.INFO, e.getMessage(), e);
                    String errorId = ErrorsHelper.addErrorIntoCollection(collection, null, e.getMessage());
                    qAttributes.put(new QName("errorId"), errorId);
                }
            } else {
                qChildren.add(FeaturesNode.replaceInvalidCharacters(node.getValue()));
            }
        }
        if (!node.getChildren().isEmpty()) {
            for (FeatureTreeNode entry : node.getChildren()) {
                qChildren.add(new JAXBElement(new QName(entry.getName()), FeaturesNode.class, (Object)FeaturesNode.fromValues(entry, collection)));
            }
        }
        if (qAttributes.isEmpty() && qChildren.isEmpty()) {
            return null;
        }
        return new FeaturesNode(qAttributes, qChildren);
    }

    private static String replaceInvalidCharacters(String source) {
        try (Formatter formatter = new Formatter();){
            for (int i = 0; i < source.length(); ++i) {
                char curChar = source.charAt(i);
                if ('#' == curChar) {
                    formatter.format("#x%06X", "#".codePointAt(0));
                    continue;
                }
                int codePoint = source.codePointAt(i);
                if (Character.isHighSurrogate(curChar)) {
                    ++i;
                }
                if (codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) {
                    formatter.format("%c", Character.valueOf(curChar));
                    if (!Character.isHighSurrogate(curChar) || i >= source.length()) continue;
                    formatter.format("%c", Character.valueOf(source.charAt(i)));
                    continue;
                }
                formatter.format("#x%06X", codePoint);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static JAXBElement<FeaturesNode> fromXmp(FeatureTreeNode xmpNode) throws SAXException, IOException, ParserConfigurationException {
        Node node = XmpHandler.parseMetadataRootElement(xmpNode);
        if (node == null) {
            return null;
        }
        FeaturesNode fromXmp = FeaturesNode.nodeFromXmlElement(node);
        return new JAXBElement(new QName(node.getNodeName()), FeaturesNode.class, (Object)fromXmp);
    }

    public static FeaturesNode nodeFromXmlElement(Node node) {
        HashMap<QName, Object> atts = new HashMap<QName, Object>();
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            for (int index = 0; index < nnm.getLength(); ++index) {
                atts.put(new QName(nnm.item(index).getNodeName()), nnm.item(index).getNodeValue());
            }
        }
        ArrayList<Object> children = new ArrayList<Object>();
        NodeList nodeList = node.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node item = nodeList.item(index);
            String nodeValue = item.getNodeValue();
            if (nodeValue == null) {
                children.add(new JAXBElement(new QName(item.getNodeName()), FeaturesNode.class, (Object)FeaturesNode.nodeFromXmlElement(item)));
                continue;
            }
            if (nodeValue.trim().isEmpty()) continue;
            children.add(nodeValue);
        }
        return new FeaturesNode(atts, children);
    }

    public Map<QName, Object> getAttributes() {
        return this.attributes;
    }

    public List<Object> getChildren() {
        return this.children;
    }
}

