/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.flavours;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum PDFAFlavour {
    NO_FLAVOUR(Specification.NO_STANDARD, Level.NO_LEVEL),
    PDFA_1_A(Specification.ISO_19005_1, Level.A),
    PDFA_1_B(Specification.ISO_19005_1, Level.B),
    PDFA_2_A(Specification.ISO_19005_2, Level.A),
    PDFA_2_B(Specification.ISO_19005_2, Level.B),
    PDFA_2_U(Specification.ISO_19005_2, Level.U),
    PDFA_3_A(Specification.ISO_19005_3, Level.A),
    PDFA_3_B(Specification.ISO_19005_3, Level.B),
    PDFA_3_U(Specification.ISO_19005_3, Level.U);

    private static final Map<String, PDFAFlavour> FLAVOUR_LOOKUP;
    private final Specification part;
    private final Level level;
    private final String id;

    private PDFAFlavour(Specification standard, Level level) {
        this.part = standard;
        this.level = level;
        this.id = this.part.getPartNumber() + this.level.getCode();
    }

    public final Specification getPart() {
        return this.part;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final String getId() {
        return this.id;
    }

    public static PDFAFlavour byFlavourId(String flavourId) {
        return FLAVOUR_LOOKUP.get(flavourId);
    }

    public static Set<String> getFlavourIds() {
        return FLAVOUR_LOOKUP.keySet();
    }

    static {
        FLAVOUR_LOOKUP = new HashMap<String, PDFAFlavour>();
        FLAVOUR_LOOKUP.put("", NO_FLAVOUR);
        FLAVOUR_LOOKUP.put(PDFA_1_A.getId(), PDFA_1_A);
        FLAVOUR_LOOKUP.put(PDFA_1_B.getId(), PDFA_1_B);
        FLAVOUR_LOOKUP.put(PDFA_2_A.getId(), PDFA_2_A);
        FLAVOUR_LOOKUP.put(PDFA_2_B.getId(), PDFA_2_B);
        FLAVOUR_LOOKUP.put(PDFA_2_U.getId(), PDFA_2_U);
        FLAVOUR_LOOKUP.put(PDFA_3_A.getId(), PDFA_3_A);
        FLAVOUR_LOOKUP.put(PDFA_3_B.getId(), PDFA_3_B);
        FLAVOUR_LOOKUP.put(PDFA_3_U.getId(), PDFA_3_U);
    }

    public static enum IsoStandardSeries {
        NO_SERIES(0, "none"),
        ISO_19005(19005, "Document management -- Electronic document file format for long-term preservation"),
        ISO_32000(32000, "Document management -- Portable document format");

        private final int id;
        private final String name;
        private final String description;

        private IsoStandardSeries(int id, String description) {
            this.id = id;
            this.name = "ISO " + this.getId();
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getName() + " " + this.getDescription();
        }
    }

    public static enum Level {
        NO_LEVEL("none", "none"),
        A("a ", "accessible"),
        B("b ", "basic"),
        U("u", "unicode");

        private final String code;
        private final String name;

        private Level(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public final String getCode() {
            return this.code;
        }

        public final String getName() {
            return this.name;
        }
    }

    public static enum Specification {
        NO_STANDARD(IsoStandardSeries.NO_SERIES, 0, "none", "none"),
        ISO_19005_1(IsoStandardSeries.ISO_19005, 1, "2005", "Use of PDF 1.4"),
        ISO_19005_2(IsoStandardSeries.ISO_19005, 2, "2011", "Use of ISO 32000-1"),
        ISO_19005_3(IsoStandardSeries.ISO_19005, 3, "2012", "Use of ISO 32000-1 with support for embedded files");

        private final IsoStandardSeries series;
        private final int partNumber;
        private final String id;
        private final String year;
        private final String name;
        private final String description;

        private Specification(IsoStandardSeries series, int partNumber, String year, String description) {
            this.series = series;
            this.partNumber = partNumber;
            this.year = year;
            this.description = description;
            this.id = this.series.getName() + "-" + this.getPartNumber() + ":" + this.getYear();
            this.name = "PDF/A-" + this.getPartNumber();
        }

        public final int getPartNumber() {
            return this.partNumber;
        }

        public final String getId() {
            return this.id;
        }

        public final String getYear() {
            return this.year;
        }

        public final String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public IsoStandardSeries getSeries() {
            return this.series;
        }

        public String toString() {
            return this.id;
        }
    }
}

