/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.verapdf.pdfa.ValidationProfile;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.ProfileDirectory;

final class ProfileDirectoryImpl
implements ProfileDirectory {
    private final Map<PDFAFlavour, ValidationProfile> profileMap;
    private final Map<String, PDFAFlavour> flavourMap;

    private ProfileDirectoryImpl(Set<ValidationProfile> profileSet) {
        this(ProfileDirectoryImpl.profileMapFromSet(profileSet));
    }

    private ProfileDirectoryImpl(Map<PDFAFlavour, ValidationProfile> profileMap) {
        this.profileMap = Collections.unmodifiableMap(profileMap);
        this.flavourMap = ProfileDirectoryImpl.flavourMapFromSet(profileMap.keySet());
    }

    @Override
    public Set<String> getValidationProfileIds() {
        return Collections.unmodifiableSet(this.flavourMap.keySet());
    }

    @Override
    public Set<PDFAFlavour> getPDFAFlavours() {
        return Collections.unmodifiableSet(this.profileMap.keySet());
    }

    @Override
    public ValidationProfile getValidationProfileById(String profileID) {
        if (profileID == null) {
            throw new IllegalArgumentException("Parameter profileID cannot be null");
        }
        PDFAFlavour flavour = this.flavourMap.get(profileID);
        if (flavour == null) {
            throw new NoSuchElementException("PDFAFlavour " + (Object)((Object)flavour) + " is not supported by this directory.");
        }
        return this.getValidationProfileByFlavour(flavour);
    }

    @Override
    public ValidationProfile getValidationProfileByFlavour(PDFAFlavour flavour) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter flavour cannot be null");
        }
        ValidationProfile profile = this.profileMap.get((Object)flavour);
        if (profile == null) {
            throw new NoSuchElementException("PDFAFlavour " + (Object)((Object)flavour) + " is not supported by this directory.");
        }
        return profile;
    }

    @Override
    public Set<ValidationProfile> getValidationProfiles() {
        return Collections.unmodifiableSet(new HashSet<ValidationProfile>(this.profileMap.values()));
    }

    static ProfileDirectory fromProfileSet(Set<ValidationProfile> profiles) {
        return new ProfileDirectoryImpl(profiles);
    }

    static Map<PDFAFlavour, ValidationProfile> profileMapFromSet(Set<ValidationProfile> profileSet) {
        HashMap<PDFAFlavour, ValidationProfile> profileMap = new HashMap<PDFAFlavour, ValidationProfile>();
        for (ValidationProfile profile : profileSet) {
            profileMap.put(profile.getPDFAFlavour(), profile);
        }
        return Collections.unmodifiableMap(profileMap);
    }

    static Map<String, PDFAFlavour> flavourMapFromSet(Set<PDFAFlavour> flavours) {
        HashMap<String, PDFAFlavour> flavourMap = new HashMap<String, PDFAFlavour>();
        for (PDFAFlavour flavour : flavours) {
            flavourMap.put(flavour.getId(), flavour);
        }
        return Collections.unmodifiableMap(flavourMap);
    }
}

