/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.verapdf.pdfa.ValidationProfile;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.Rule;
import org.verapdf.pdfa.validation.Variable;

@XmlRootElement(namespace="http://www.verapdf.org/ValidationProfile", name="profile")
final class ValidationProfileImpl
implements ValidationProfile {
    private static final ValidationProfileImpl DEFAULT = new ValidationProfileImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlElement
    private final String name;
    @XmlElement
    private final String description;
    @XmlAttribute
    private final String creator;
    @XmlAttribute
    private final Date created;
    @XmlElement
    private final String hash;
    @XmlElementWrapper
    @XmlElement(name="rule")
    private final Set<Rule> rules;
    @XmlElementWrapper
    @XmlElement(name="variable")
    private final Set<Variable> variables;

    private ValidationProfileImpl() {
        this(PDFAFlavour.NO_FLAVOUR, "name", "description", "creator", new Date(0L), "hash", Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    private ValidationProfileImpl(PDFAFlavour flavour, String name, String description, String creator, Date created, String hash, Set<Rule> rules, Set<Variable> variables) {
        this.flavour = flavour;
        this.name = name;
        this.description = description;
        this.creator = creator;
        this.created = created;
        this.hash = hash;
        this.rules = new HashSet<Rule>(rules);
        this.variables = new HashSet<Variable>(variables);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public PDFAFlavour getPDFAFlavour() {
        return this.flavour;
    }

    @Override
    public Date getDateCreated() {
        return this.created;
    }

    @Override
    public String getHexSha1Digest() {
        return this.hash;
    }

    @Override
    public Set<Rule> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    @Override
    public Set<Variable> getVariables() {
        return Collections.unmodifiableSet(this.variables);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.creator == null ? 0 : this.creator.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.rules == null ? 0 : this.rules.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationProfile)) {
            return false;
        }
        ValidationProfile other = (ValidationProfile)obj;
        if (this.created == null ? other.getDateCreated() != null : !this.created.equals(other.getDateCreated())) {
            return false;
        }
        if (this.creator == null ? other.getCreator() != null : !this.creator.equals(other.getCreator())) {
            return false;
        }
        if (this.description == null ? other.getDescription() != null : !this.description.equals(other.getDescription())) {
            return false;
        }
        if (this.flavour != other.getPDFAFlavour()) {
            return false;
        }
        if (this.hash == null ? other.getHexSha1Digest() != null : !this.hash.equals(other.getHexSha1Digest())) {
            return false;
        }
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.rules == null ? other.getRules() != null : !this.rules.equals(other.getRules())) {
            return false;
        }
        return !(this.variables == null ? other.getVariables() != null : !this.variables.equals(other.getVariables()));
    }

    public String toString() {
        return "ValidationProfile [flavour=" + (Object)((Object)this.flavour) + ", name=" + this.name + ", description=" + this.description + ", creator=" + this.creator + ", created=" + this.created + ", hash=" + this.hash + ", rules=" + this.rules + ", variables=" + this.variables + "]";
    }

    static ValidationProfileImpl defaultInstance() {
        return DEFAULT;
    }

    static ValidationProfileImpl fromValues(PDFAFlavour flavour, String name, String description, String creator, Date created, String hash, Set<Rule> rules, Set<Variable> variables) {
        return new ValidationProfileImpl(flavour, name, description, creator, created, hash, rules, variables);
    }

    static ValidationProfileImpl fromValidationProfile(ValidationProfile toConvert) {
        return ValidationProfileImpl.fromValues(toConvert.getPDFAFlavour(), toConvert.getName(), toConvert.getDescription(), toConvert.getCreator(), toConvert.getDateCreated(), toConvert.getHexSha1Digest(), toConvert.getRules(), toConvert.getVariables());
    }

    static String toXml(ValidationProfile toConvert, Boolean prettyXml) throws JAXBException, IOException {
        String retVal = "";
        try (StringWriter writer = new StringWriter();){
            ValidationProfileImpl.toXml(toConvert, writer, prettyXml);
            String string = retVal = writer.toString();
            return string;
        }
    }

    static ValidationProfileImpl fromXml(String toConvert) throws JAXBException {
        try (StringReader reader = new StringReader(toConvert);){
            ValidationProfileImpl validationProfileImpl = ValidationProfileImpl.fromXml(reader);
            return validationProfileImpl;
        }
    }

    static void toXml(ValidationProfile toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ValidationProfileImpl.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    static ValidationProfileImpl fromXml(InputStream toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = ValidationProfileImpl.getUnmarshaller();
        return (ValidationProfileImpl)stringUnmarshaller.unmarshal(toConvert);
    }

    static void toXml(ValidationProfile toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = ValidationProfileImpl.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, writer);
    }

    static ValidationProfileImpl fromXml(Reader toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = ValidationProfileImpl.getUnmarshaller();
        return (ValidationProfileImpl)stringUnmarshaller.unmarshal(toConvert);
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationProfileImpl.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidationProfileImpl.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }
}

