/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.features.FeaturesData;

public final class ImageFeaturesData
extends FeaturesData {
    private static final Logger LOGGER = Logger.getLogger(ImageFeaturesData.class.getCanonicalName());
    private final InputStream metadata;
    private final Integer width;
    private final Integer height;
    private final List<Filter> filters;

    private ImageFeaturesData(InputStream metadata, InputStream stream, Integer width, Integer height, List<Filter> filters) {
        super(stream);
        this.metadata = metadata;
        this.width = width;
        this.height = height;
        if (filters == null) {
            this.filters = null;
        } else {
            this.filters = new ArrayList<Filter>();
            for (Filter fs : filters) {
                this.filters.add(new Filter(fs.name, fs.properties, fs.stream));
            }
        }
    }

    public static ImageFeaturesData newInstance(InputStream metadata, InputStream stream, Integer width, Integer height, List<Filter> filters) {
        if (stream == null) {
            throw new IllegalArgumentException("Image stream can not be null");
        }
        return new ImageFeaturesData(metadata, stream, width, height, filters);
    }

    public InputStream getMetadata() {
        return this.metadata;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public List<Filter> getFilters() {
        return this.filters == null ? null : Collections.unmodifiableList(this.filters);
    }

    @Override
    public void close() throws IOException {
        try {
            this.metadata.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Exception during metadata closing", e);
        }
        if (this.filters != null) {
            for (Filter f : this.filters) {
                f.close();
            }
        }
        super.close();
    }

    public static class Filter
    implements Closeable {
        private static final Logger LOGGER = Logger.getLogger(Filter.class.getCanonicalName());
        private final String name;
        private final Map<String, String> properties;
        private final InputStream stream;

        Filter(String name, Map<String, String> properties, InputStream stream) {
            this.name = name;
            this.properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
            this.stream = stream;
        }

        public static Filter newInstance(String name, Map<String, String> properties, InputStream stream) {
            if (name == null) {
                throw new IllegalArgumentException("Name of a filter can not be null");
            }
            if (properties == null) {
                throw new IllegalArgumentException("Properties can not be null");
            }
            return new Filter(name, properties, stream);
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public InputStream getStream() {
            return this.stream;
        }

        @Override
        public void close() throws IOException {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Exception during filter closing", e);
            }
        }
    }
}

