/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp;

import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.List;
import java.util.regex.Pattern;
import org.verapdf.model.tools.xmp.PredefinedSchemasDefinition;
import org.verapdf.model.tools.xmp.SchemasDefinition;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.ValidatorsContainerCreator;
import org.verapdf.model.tools.xmp.XMPConstants;

public class SchemasDefinitionCreator {
    public static final SchemasDefinition EMPTY_SCHEMAS_DEFINITION = new SchemasDefinition();
    private static SchemasDefinition PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1 = null;
    private static SchemasDefinition PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3 = null;
    private static SchemasDefinition PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_1 = null;
    private static SchemasDefinition PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_2_3 = null;

    public static SchemasDefinition getPredefinedSchemaDefinitionForPDFA_1(boolean isClosedFieldsCheck) {
        if (isClosedFieldsCheck) {
            if (PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_1 == null) {
                PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_1 = SchemasDefinitionCreator.createPredefinedPDFA_1SchemasDefinition(true);
            }
            return PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_1;
        }
        if (PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1 == null) {
            PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1 = SchemasDefinitionCreator.createPredefinedPDFA_1SchemasDefinition(false);
        }
        return PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1;
    }

    public static SchemasDefinition getPredefinedSchemaDefinitionForPDFA_2_3(boolean isClosedFieldsCheck) {
        if (isClosedFieldsCheck) {
            if (PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_2_3 == null) {
                PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_2_3 = SchemasDefinitionCreator.createPredefinedPDFA_2_3SchemasDefinition(true);
            }
            return PREDEFINED_SCHEMA_DEFINITION_WITH_CLOSED_CHOICE_FOR_PDFA_2_3;
        }
        if (PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3 == null) {
            PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3 = SchemasDefinitionCreator.createPredefinedPDFA_2_3SchemasDefinition(false);
        }
        return PREDEFINED_SCHEMA_DEFINITION_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3;
    }

    public static SchemasDefinition createExtendedSchemasDefinitionForPDFA_1(VeraPDFXMPNode schemas, boolean isClosedFieldsCheck) {
        return SchemasDefinitionCreator.createExtendedSchemasDefinition(schemas, true, isClosedFieldsCheck);
    }

    public static SchemasDefinition createExtendedSchemasDefinitionForPDFA_2_3(VeraPDFXMPNode schemas, boolean isClosedFieldsCheck) {
        return SchemasDefinitionCreator.createExtendedSchemasDefinition(schemas, false, isClosedFieldsCheck);
    }

    private static SchemasDefinition createExtendedSchemasDefinition(VeraPDFXMPNode schemas, boolean isPDFA_1, boolean isClosedFieldsCheck) {
        if (schemas == null) {
            return EMPTY_SCHEMAS_DEFINITION;
        }
        if (!("http://www.aiim.org/pdfa/ns/extension/".equals(schemas.getNamespaceURI()) && "schemas".equals(schemas.getName()) && schemas.getOptions().isArray())) {
            return EMPTY_SCHEMAS_DEFINITION;
        }
        ValidatorsContainer typeContainer = isPDFA_1 ? ValidatorsContainerCreator.createExtendedValidatorsContainerForPDFA_1(schemas, isClosedFieldsCheck) : ValidatorsContainerCreator.createExtendedValidatorsContainerForPDFA_2_3(schemas, isClosedFieldsCheck);
        SchemasDefinition res = new SchemasDefinition(typeContainer);
        List schemasNodes = schemas.getChildren();
        for (VeraPDFXMPNode node : schemasNodes) {
            SchemasDefinitionCreator.registerAllPropertiesFromExtensionSchemaNode(node, res);
        }
        return res;
    }

    private static void registerAllPropertiesFromExtensionSchemaNode(VeraPDFXMPNode schema, SchemasDefinition schemasDefinition) {
        List schemaChildren = schema.getChildren();
        VeraPDFXMPNode propertyNode = null;
        String namespaceURI = null;
        for (VeraPDFXMPNode child : schemaChildren) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI())) continue;
            switch (child.getName()) {
                case "property": {
                    if (!child.getOptions().isArray()) break;
                    propertyNode = child;
                    break;
                }
                case "namespaceURI": {
                    namespaceURI = child.getValue();
                    break;
                }
            }
        }
        if (namespaceURI != null && propertyNode != null) {
            SchemasDefinitionCreator.registerAllPropertiesFromPropertyArrayNode(namespaceURI, propertyNode, schemasDefinition);
        }
    }

    private static void registerAllPropertiesFromPropertyArrayNode(String namespace, VeraPDFXMPNode properties, SchemasDefinition schemasDefinition) {
        List children = properties.getChildren();
        for (VeraPDFXMPNode node : children) {
            SchemasDefinitionCreator.registerPropertyNode(namespace, node, schemasDefinition);
        }
    }

    private static void registerPropertyNode(String namespace, VeraPDFXMPNode property, SchemasDefinition schemasDefinition) {
        String name = null;
        String valueType = null;
        for (VeraPDFXMPNode child : property.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI())) continue;
            switch (child.getName()) {
                case "name": {
                    name = child.getValue();
                    break;
                }
                case "valueType": {
                    valueType = child.getValue();
                    break;
                }
            }
        }
        if (name != null && valueType != null) {
            schemasDefinition.registerProperty(namespace, name, valueType);
        }
    }

    private static PredefinedSchemasDefinition createPredefinedPDFA_1SchemasDefinition(boolean isClosedFieldsCheck) {
        PredefinedSchemasDefinition schemas = SchemasDefinitionCreator.createBasicSchemasDefinition(ValidatorsContainerCreator.getPredefinedContainerForPDFA_1(isClosedFieldsCheck), isClosedFieldsCheck);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getPhotoshopDiffer1(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getExifWithoutRestrictedFieldDiffer1(), schemas);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getPdfaIdentificationRestrictedFieldDiffer1(), schemas, isClosedFieldsCheck);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getExifRestrictedFieldDiffer1(), schemas, isClosedFieldsCheck);
        return schemas;
    }

    private static PredefinedSchemasDefinition createPredefinedPDFA_2_3SchemasDefinition(boolean isClosedFieldsCheck) {
        PredefinedSchemasDefinition schemas = SchemasDefinitionCreator.createBasicSchemasDefinition(ValidatorsContainerCreator.getPredefinedContainerForPDFA_2_3(isClosedFieldsCheck), isClosedFieldsCheck);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getPdfaIdentificationSpecified23(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpBasicSpecified23(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpPagedTextSpecified23(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpDynamicMediaWithoutRestrictedFieldSpecified23(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getPhotoshopDiffer23(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getCameraRawWithoutRestrictedFieldSpecified23(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getExifWithoutRestrictedFieldDiffer23(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getAuxSpecified23(), schemas);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getPdfaIdentificationRestrictedFieldDiffer23(), schemas, isClosedFieldsCheck);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getXmpDynamicMediaRestrictedFieldSpecified23(), schemas, isClosedFieldsCheck);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getCameraRawRestrictedFieldSpecified23(), schemas, isClosedFieldsCheck);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getExifRestrictedFieldDiffer23(), schemas, isClosedFieldsCheck);
        String[] cameraRawSeqOfPointsSpecified23 = XMPConstants.getCameraRawSeqOfPointsSpecified23();
        SchemasDefinitionCreator.registerRestrictedSeqTextFieldForSchema(cameraRawSeqOfPointsSpecified23[0], cameraRawSeqOfPointsSpecified23[1], cameraRawSeqOfPointsSpecified23[2], "seq text", schemas, isClosedFieldsCheck);
        return schemas;
    }

    private static PredefinedSchemasDefinition createBasicSchemasDefinition(ValidatorsContainer typeContainer, boolean isClosedFieldsCheck) {
        PredefinedSchemasDefinition schemas = new PredefinedSchemasDefinition(typeContainer);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getPdfaIdentificationCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getDublinCoreCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpBasicCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpRightsCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpMediaManagementCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpBasicJobCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getXmpPagedTextCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getAdobePdfCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getPhotoshopCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getTiffWithoutRestrictedFieldCommon(), schemas);
        SchemasDefinitionCreator.registerStructureTypeForSchema(XMPConstants.getExifWithoutRestrictedFieldCommon(), schemas);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getTiffRestrictedFieldCommon(), schemas, isClosedFieldsCheck);
        SchemasDefinitionCreator.registerRestrictedSimpleFieldForSchema(XMPConstants.getExifRestrictedFieldCommon(), schemas, isClosedFieldsCheck);
        SchemasDefinitionCreator.registerSeqChoiceFieldForSchema("http://ns.adobe.com/tiff/1.0/", "YCbCrSubSampling", XMPConstants.getTiffYcbcrsubsamplingSeqChoiceCommon(), "seq integer", schemas, isClosedFieldsCheck);
        SchemasDefinitionCreator.registerSeqChoiceFieldForSchema("http://ns.adobe.com/exif/1.0/", "ComponentsConfiguration", XMPConstants.getExifComponentsConfigurationClosedSeqChoiceCommon(), "seq integer", schemas, isClosedFieldsCheck);
        return schemas;
    }

    private static void registerStructureTypeForSchema(String[] structure, SchemasDefinition schema) {
        for (int i = 1; i < structure.length; i += 2) {
            schema.registerProperty(structure[0], structure[i], structure[i + 1]);
        }
    }

    private static void registerRestrictedSimpleFieldForSchema(String[] structure, PredefinedSchemasDefinition schema, boolean isClosedFieldsCheck) {
        if (isClosedFieldsCheck) {
            for (int i = 1; i < structure.length; i += 3) {
                schema.registerRestrictedSimpleFieldProperty(structure[0], structure[i], Pattern.compile(structure[i + 2]));
            }
        } else {
            for (int i = 1; i < structure.length; i += 3) {
                schema.registerProperty(structure[0], structure[i], structure[i + 1]);
            }
        }
    }

    private static void registerSeqChoiceFieldForSchema(String namespaceURI, String propertyName, String[][] structure, String type, PredefinedSchemasDefinition schema, boolean isClosedFieldsCheck) {
        if (isClosedFieldsCheck) {
            schema.registerSeqChoiceProperty(namespaceURI, propertyName, structure);
        } else {
            schema.registerProperty(namespaceURI, propertyName, type);
        }
    }

    private static void registerRestrictedSeqTextFieldForSchema(String namespaceURI, String propertyName, String regex, String type, PredefinedSchemasDefinition schema, boolean isClosedFieldsCheck) {
        if (isClosedFieldsCheck) {
            schema.registerRestrictedSeqTextProperty(namespaceURI, propertyName, Pattern.compile(regex));
        } else {
            schema.registerProperty(namespaceURI, propertyName, type);
        }
    }
}

