/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.XsltTransformer;

public final class HTMLReport {
    private static final String resourceRoot = "org/verapdf/report/";
    private static final String xslExt = ".xsl";
    private static final String detailedReport = "org/verapdf/report/DetailedHtmlReport.xsl";
    private static final String summaryReport = "org/verapdf/report/SummaryHtmlReport.xsl";

    private HTMLReport() {
    }

    public static void writeHTMLReport(InputStream source, OutputStream destination, BatchSummary summary, String wikiPath, boolean isFullHTML) throws TransformerException {
        String reportPath = summary.getJobs() > 1 ? summaryReport : detailedReport;
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("wikiPath", wikiPath);
        arguments.put("isFullHTML", Boolean.toString(isFullHTML));
        XsltTransformer.transform(source, HTMLReport.class.getClassLoader().getResourceAsStream(reportPath), destination, arguments);
    }
}

