/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.processor.reports.AbstractBatchJobSummary;
import org.verapdf.processor.reports.ValidationBatchSummary;

@XmlRootElement(name="validationReports")
final class ValidationBatchSummaryImpl
extends AbstractBatchJobSummary
implements ValidationBatchSummary {
    static final ValidationBatchSummary DEFAULT = new ValidationBatchSummaryImpl();
    @XmlAttribute
    private final int compliant;
    @XmlAttribute
    private final int nonCompliant;

    private ValidationBatchSummaryImpl() {
        this(0, 0, 0);
    }

    private ValidationBatchSummaryImpl(int compliant, int nonCompliant, int failedJobs) {
        super(compliant + nonCompliant + failedJobs, failedJobs);
        assert (compliant >= 0 && nonCompliant >= 0);
        this.compliant = compliant;
        this.nonCompliant = nonCompliant;
    }

    @Override
    public int getCompliantPdfaCount() {
        return this.compliant;
    }

    @Override
    public int getNonCompliantPdfaCount() {
        return this.nonCompliant;
    }

    @Override
    public int getFailedJobCount() {
        return this.failedJobs;
    }

    @Override
    public int getTotalJobCount() {
        return this.totalJobs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.totalJobs;
        result = 31 * result + this.failedJobs;
        result = 31 * result + this.compliant;
        result = 31 * result + this.nonCompliant;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationBatchSummaryImpl)) {
            return false;
        }
        ValidationBatchSummaryImpl other = (ValidationBatchSummaryImpl)obj;
        if (this.totalJobs != other.totalJobs) {
            return false;
        }
        if (this.failedJobs != other.failedJobs) {
            return false;
        }
        if (this.compliant != other.compliant) {
            return false;
        }
        return this.nonCompliant == other.nonCompliant;
    }

    static ValidationBatchSummary defaultInstance() {
        return DEFAULT;
    }

    static ValidationBatchSummary fromValues(int compliant, int nonCompliant, int failedJobs) {
        return new ValidationBatchSummaryImpl(compliant, nonCompliant, failedJobs);
    }

    static class Adapter
    extends XmlAdapter<ValidationBatchSummaryImpl, ValidationBatchSummary> {
        Adapter() {
        }

        public ValidationBatchSummary unmarshal(ValidationBatchSummaryImpl summary) {
            return summary;
        }

        public ValidationBatchSummaryImpl marshal(ValidationBatchSummary summary) {
            return (ValidationBatchSummaryImpl)summary;
        }
    }
}

