/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="releaseDetails")
public final class ReleaseDetails {
    private static final Logger LOGGER = Logger.getLogger(ReleaseDetails.class.getCanonicalName());
    public static final String APPLICATION_PROPERTIES_ROOT = "org/verapdf/release/";
    public static final String PROPERTIES_EXT = "properties";
    public static final String LIBRARY_DETAILS_RESOURCE = "org/verapdf/release/library.properties";
    private static final String RAW_DATE_FORMAT = "${maven.build.timestamp.format}";
    private static final String RIGHTS = "Developed and released by the veraPDF Consortium.\nFunded by the PREFORMA project.\nReleased under the GNU General Public License v3\nand the Mozilla Public License v2 or later.\n";
    private static final ReleaseDetails DEFAULT = new ReleaseDetails();
    private static final Map<String, ReleaseDetails> DETAILS = ReleaseDetails.initDetailsMap();
    @XmlAttribute
    private final String id;
    @XmlAttribute
    private final String version;
    @XmlAttribute
    private final Date buildDate;

    private ReleaseDetails() {
        this("name", "version", new Date());
    }

    private ReleaseDetails(String id, String version, Date buildDate) {
        this.id = id;
        this.version = version;
        this.buildDate = new Date(buildDate.getTime());
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getBuildDate() {
        return new Date(this.buildDate.getTime());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.buildDate == null ? 0 : this.buildDate.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseDetails other = (ReleaseDetails)obj;
        if (this.buildDate == null ? other.buildDate != null : !this.buildDate.equals(other.buildDate)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "ReleaseDetails [id=" + this.id + ", version=" + this.version + ", buildDate=" + this.buildDate + "]";
    }

    public static ReleaseDetails defaultInstance() {
        return DEFAULT;
    }

    public static String rightsStatement() {
        return RIGHTS;
    }

    public static ReleaseDetails getInstance() {
        if (DETAILS.isEmpty()) {
            return ReleaseDetails.defaultInstance();
        }
        return DETAILS.values().toArray(new ReleaseDetails[DETAILS.size()])[0];
    }

    public static Set<String> getIds() {
        return DETAILS.keySet();
    }

    public static ReleaseDetails byId(String id) {
        if (DETAILS.containsKey(id)) {
            return DETAILS.get(id);
        }
        return ReleaseDetails.defaultInstance();
    }

    public static Collection<ReleaseDetails> getDetails() {
        return DETAILS.values();
    }

    public static ReleaseDetails addDetailsFromResource(String resourceName) {
        ReleaseDetails details = ReleaseDetails.fromResource(resourceName);
        DETAILS.put(details.id, details);
        return details;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ReleaseDetails fromResource(String resourceName) {
        try (InputStream is = ReleaseDetails.class.getClassLoader().getResourceAsStream(resourceName);){
            if (is == null) {
                ReleaseDetails releaseDetails2 = DEFAULT;
                return releaseDetails2;
            }
            ReleaseDetails releaseDetails = ReleaseDetails.fromPropertiesStream(is);
            return releaseDetails;
        }
        catch (IOException excep) {
            throw new IllegalStateException("Couldn't load ReleaseDetails resource:" + resourceName, excep);
        }
    }

    private static ReleaseDetails fromPropertiesStream(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return ReleaseDetails.fromProperties(props);
    }

    private static ReleaseDetails fromProperties(Properties props) {
        String release = props.getProperty("verapdf.release.version");
        String dateFormat = props.getProperty("verapdf.date.format");
        String id = props.getProperty("verapdf.project.id");
        Date date = new Date();
        if (!dateFormat.equals(RAW_DATE_FORMAT)) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            try {
                date = formatter.parse(props.getProperty("verapdf.release.date"));
            }
            catch (ParseException e) {
                LOGGER.log(Level.FINEST, "No parsable release date found, setting release date to:" + date, e);
            }
        }
        return new ReleaseDetails(id, release, date);
    }

    private static Map<String, ReleaseDetails> initDetailsMap() {
        HashMap<String, ReleaseDetails> details = new HashMap<String, ReleaseDetails>();
        ReleaseDetails libDetails = ReleaseDetails.fromResource(LIBRARY_DETAILS_RESOURCE);
        details.put(libDetails.id, libDetails);
        return details;
    }
}

