/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.parsers.pkcs7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.verapdf.pdfa.parsers.pkcs7.DEREncodedInputStream;
import org.verapdf.pdfa.parsers.pkcs7.IndefiniteLengthConverter;
import org.verapdf.pdfa.parsers.pkcs7.InputBuffer;

public class DEREncodedValue {
    public byte valueTag;
    public final DEREncodedInputStream in;
    private int length;
    public static final byte TAG_SEQUENCE = 48;
    public static final byte TAG_SET = 49;
    public static final byte TAG_OBJECT_ID = 6;
    public static final byte TAG_BIT_STRING = 3;
    public static final byte TAG_NULL = 5;
    public static final byte TAG_INTEGER = 2;
    public static final byte TAG_UTC_TIME = 23;
    public static final byte TAG_GENERALIZED_TIME = 24;

    public DEREncodedValue(byte valueTag, byte[] bytes) {
        this.length = bytes.length;
        this.valueTag = valueTag;
        this.in = new DEREncodedInputStream(new InputBuffer((byte[])bytes.clone()));
        this.in.mark(Integer.MAX_VALUE);
    }

    public DEREncodedValue(InputBuffer in) throws IOException {
        this.valueTag = (byte)in.read();
        byte lengthByte = (byte)in.read();
        this.length = DEREncodedInputStream.getLength(lengthByte, in);
        if (this.length == -1) {
            InputBuffer buffer = new InputBuffer(IndefiniteLengthConverter.convertStream(in.dup(), lengthByte, this.valueTag));
            if (this.valueTag != buffer.read()) {
                throw new IOException("Data length is indefinite");
            }
            this.length = DEREncodedInputStream.getDefLength(buffer);
            InputBuffer inputBuffer = buffer.dup();
            inputBuffer.truncate(this.length);
            this.in = new DEREncodedInputStream(inputBuffer);
            in.skip(this.length + 2);
        } else {
            InputBuffer inputBuffer = in.dup();
            inputBuffer.truncate(this.length);
            this.in = new DEREncodedInputStream(inputBuffer);
            in.skip(this.length);
        }
    }

    public boolean areEmpty() {
        return this.length == 0;
    }

    public final byte getValueTag() {
        return this.valueTag;
    }

    public byte[] getBitString() throws IOException {
        if (this.valueTag == 3) {
            return this.in.inputBuffer.getBitString();
        }
        throw new IOException("Invalid bit string tag: " + this.valueTag);
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.valueTag == 2) {
            return this.in.inputBuffer.getBigInteger(this.in.available());
        }
        throw new IOException("Invalid Integer tag: " + this.valueTag);
    }

    public boolean isConstructed() {
        return (this.valueTag & 0x20) == 32;
    }

    public boolean isContextSpecific(byte tag) {
        if ((this.valueTag & 0xC0) != 128) {
            return false;
        }
        return (this.valueTag & 0x1F) == tag;
    }

    public DEREncodedInputStream toDEREncodedInputStream() throws IOException {
        if (this.valueTag != 49 && this.valueTag != 48) {
            throw new IOException("Invalid tag type " + this.valueTag + " while converting to DEREncodedInputStream");
        }
        return new DEREncodedInputStream(this.in.inputBuffer);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.encode(stream);
        this.in.reset();
        return stream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ByteArrayOutputStream stream) throws IOException {
        stream.write(this.valueTag);
        this.putLen(stream, this.length);
        if (this.length > 0) {
            byte[] val = new byte[this.length];
            DEREncodedInputStream dEREncodedInputStream = this.in;
            synchronized (dEREncodedInputStream) {
                this.in.inputBuffer.reset();
                if (this.in.inputBuffer.read(val) != this.length) {
                    throw new IOException("Invalid reading of DER value");
                }
                stream.write(val);
            }
        }
    }

    public void putLen(ByteArrayOutputStream out, int length) {
        byte[] lengthBytes = IndefiniteLengthConverter.getLenBytes(length);
        out.write(lengthBytes, 0, lengthBytes.length);
    }
}

