/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.Variable;

public class JavaScriptEvaluator {
    private static final int OPTIMIZATION_LEVEL = 9;
    private static Context context;
    private static Map<String, Script> ruleScripts;
    private static Map<String, Script> variableScripts;
    private static Map<String, Script> argumentScripts;

    public static synchronized ScriptableObject initialise() {
        context = Context.enter();
        context.setOptimizationLevel(9);
        return context.initStandardObjects();
    }

    public static synchronized java.lang.Object evaluateString(String source, ScriptableObject scope) {
        return context.evaluateString((Scriptable)scope, source, null, 0, null);
    }

    public static synchronized java.lang.Object evalVariableResult(Variable variable, Object object, ScriptableObject scope) {
        Script script;
        if (!variableScripts.containsKey(variable.getName())) {
            String source = JavaScriptEvaluator.getStringScript(object, variable.getValue());
            script = JavaScriptEvaluator.compileString(source);
            variableScripts.put(variable.getName(), script);
        } else {
            script = variableScripts.get(variable.getName());
        }
        scope.put("obj", (Scriptable)scope, (java.lang.Object)object);
        java.lang.Object res = script.exec(context, (Scriptable)scope);
        if (res instanceof NativeJavaObject) {
            res = ((NativeJavaObject)res).unwrap();
        }
        return res;
    }

    private static Script compileString(String source) {
        return context.compileString(source, null, 0, null);
    }

    private static String getStringScript(Object obj, String arg) {
        return JavaScriptEvaluator.getScriptPrefix(obj, arg) + arg + JavaScriptEvaluator.getScriptSuffix();
    }

    private static String getScriptPrefix(Object obj, String test) {
        StringBuilder builder = new StringBuilder();
        String[] vars = test.split("\\W");
        for (String prop : obj.getProperties()) {
            if (!JavaScriptEvaluator.contains(vars, prop)) continue;
            builder.append("var ");
            builder.append(prop);
            builder.append(" = obj.get");
            builder.append(prop);
            builder.append("();\n");
        }
        for (String linkName : obj.getLinks()) {
            if (!JavaScriptEvaluator.contains(vars, linkName + "_size")) continue;
            builder.append("var ");
            builder.append(linkName);
            builder.append("_size = obj.getLinkedObjects(\"");
            builder.append(linkName);
            builder.append("\").size();\n");
        }
        builder.append("function test(){return ");
        return builder.toString();
    }

    private static boolean contains(String[] values, String prop) {
        for (String value : values) {
            if (!value.equals(prop)) continue;
            return true;
        }
        return false;
    }

    private static String getScriptSuffix() {
        return ";}\ntest();";
    }

    private static String getScript(Object obj, String test) {
        return JavaScriptEvaluator.getStringScript(obj, "(" + test + ")==true");
    }

    public static synchronized boolean getTestEvalResult(Object obj, Rule rule, ScriptableObject scope) {
        Script scr;
        scope.put("obj", (Scriptable)scope, (java.lang.Object)obj);
        String test = rule.getTest();
        if (!ruleScripts.containsKey(test)) {
            scr = JavaScriptEvaluator.compileString(JavaScriptEvaluator.getScript(obj, test));
            ruleScripts.put(test, scr);
        } else {
            scr = ruleScripts.get(test);
        }
        boolean testEvalResult = (Boolean)scr.exec(context, (Scriptable)scope);
        return testEvalResult;
    }

    private static synchronized String getErrorArgumentResult(String argument, Object obj, ScriptableObject scope) {
        Script scr;
        if (!argumentScripts.containsKey(argument)) {
            scr = JavaScriptEvaluator.compileString(JavaScriptEvaluator.getStringScript(obj, argument));
            argumentScripts.put(argument, scr);
        } else {
            scr = argumentScripts.get(argument);
        }
        java.lang.Object res = scr.exec(context, (Scriptable)scope);
        if (res instanceof NativeJavaObject) {
            res = ((NativeJavaObject)res).unwrap();
        }
        if (res instanceof Double && Math.abs((Double)res - Math.floor((Double)res)) < 1.0E-7) {
            return Integer.toString(((Double)res).intValue());
        }
        return res != null ? res.toString() : null;
    }

    public static synchronized List<String> getErrorArgumentsResult(Object obj, List<String> arguments, ScriptableObject scope) {
        ArrayList<String> result = new ArrayList<String>(arguments.size());
        for (String argument : arguments) {
            result.add(JavaScriptEvaluator.getErrorArgumentResult(argument, obj, scope));
        }
        return result;
    }

    public static void exitContext() {
        Context.exit();
    }

    static {
        ruleScripts = new HashMap<String, Script>();
        variableScripts = new HashMap<String, Script>();
        argumentScripts = new HashMap<String, Script>();
    }
}

