/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports.multithread.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.writer.ReportWriter;

public class JsonReportWriter
extends ReportWriter {
    private static final Logger LOGGER = Logger.getLogger(JsonReportWriter.class.getCanonicalName());
    protected boolean isFirstReport;

    protected JsonReportWriter(OutputStream os, OutputStream errorStream) {
        super(os, errorStream);
    }

    @Override
    public void write(ResultStructure result) {
        if (this.isFirstReport) {
            this.isFirstReport = false;
        } else {
            try {
                this.os.write(",".getBytes());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't write", e);
            }
        }
        this.merge(result.getReportFile(), this.os);
        this.deleteTemp(result);
    }

    @Override
    public void startDocument() {
        try {
            this.os.write("{\"reports\":[".getBytes());
            this.isFirstReport = true;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't write start document", e);
        }
    }

    @Override
    public void endDocument() {
        try {
            this.os.write("]}".getBytes());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't write end document", e);
        }
    }
}

